/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Iterator;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.postgresql.pljava.internal.Backend;

public class PgSavepoint
implements Savepoint {
    private static final WeakHashMap s_knownSavepoints = new WeakHashMap();
    private long m_pointer;

    PgSavepoint(long pointer) {
        this.m_pointer = pointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PgSavepoint set(String name) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            PgSavepoint sp = new PgSavepoint(PgSavepoint._set(name));
            s_knownSavepoints.put(sp, Boolean.TRUE);
            return sp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PgSavepoint forId(int savepointId) {
        if (savepointId != 0) {
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                Iterator itor = s_knownSavepoints.keySet().iterator();
                while (itor.hasNext()) {
                    PgSavepoint sp = (PgSavepoint)itor.next();
                    if (savepointId != PgSavepoint._getId(sp.m_pointer)) continue;
                    return sp;
                }
            }
        }
        return null;
    }

    public int hashCode() {
        return this.getSavepointId();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            PgSavepoint._release(this.m_pointer);
            s_knownSavepoints.remove(this);
            this.m_pointer = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            PgSavepoint._rollback(this.m_pointer);
            s_knownSavepoints.remove(this);
            this.m_pointer = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSavepointName() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return PgSavepoint._getName(this.m_pointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSavepointId() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return PgSavepoint._getId(this.m_pointer);
        }
    }

    public void onInvocationExit(Connection conn) throws SQLException {
        if (this.m_pointer == 0L) {
            return;
        }
        Logger logger = Logger.getAnonymousLogger();
        if (Backend.isReleaseLingeringSavepoints()) {
            logger.warning("Releasing savepoint '" + PgSavepoint._getId(this.m_pointer) + "' since its lifespan exceeds that of the function where it was set");
            conn.releaseSavepoint(this);
        } else {
            logger.warning("Rolling back to savepoint '" + PgSavepoint._getId(this.m_pointer) + "' since its lifespan exceeds that of the function where it was set");
            conn.rollback(this);
        }
    }

    private static native long _set(String var0) throws SQLException;

    private static native void _release(long var0) throws SQLException;

    private static native void _rollback(long var0) throws SQLException;

    private static native String _getName(long var0);

    private static native int _getId(long var0);
}

