/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.postgresql.pljava.ObjectPool;
import org.postgresql.pljava.SavepointListener;
import org.postgresql.pljava.TransactionListener;
import org.postgresql.pljava.internal.AclId;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.ELogHandler;
import org.postgresql.pljava.internal.ObjectPoolImpl;
import org.postgresql.pljava.internal.SubXactListener;
import org.postgresql.pljava.internal.TransactionalMap;
import org.postgresql.pljava.internal.XactListener;
import org.postgresql.pljava.jdbc.SQLUtils;

public class Session
implements org.postgresql.pljava.Session {
    private final TransactionalMap m_attributes = new TransactionalMap((Map)new HashMap());

    public void addTransactionListener(TransactionListener listener) {
        XactListener.addListener(listener);
    }

    public void addSavepointListener(SavepointListener listener) {
        SubXactListener.addListener(listener);
    }

    public Object getAttribute(String attributeName) {
        return this.m_attributes.get(attributeName);
    }

    public ObjectPool getObjectPool(Class cls) {
        return ObjectPoolImpl.getObjectPool(cls);
    }

    public String getUserName() {
        return AclId.getUser().getName();
    }

    public String getSessionUserName() {
        return AclId.getSessionUser().getName();
    }

    public void removeAttribute(String attributeName) {
        this.m_attributes.remove(attributeName);
    }

    public void setAttribute(String attributeName, Object value) {
        this.m_attributes.put(attributeName, value);
    }

    public void removeTransactionListener(TransactionListener listener) {
        XactListener.removeListener(listener);
    }

    public void removeSavepointListener(SavepointListener listener) {
        SubXactListener.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAsSessionUser(Connection conn, String statement) throws SQLException {
        Statement stmt = conn.createStatement();
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            ResultSet rs = null;
            AclId sessionUser = AclId.getSessionUser();
            AclId effectiveUser = AclId.getUser();
            try {
                Session._setUser(sessionUser);
                if (stmt.execute(statement)) {
                    rs = stmt.getResultSet();
                    rs.next();
                }
            }
            finally {
                SQLUtils.close(rs);
                SQLUtils.close(stmt);
                Session._setUser(effectiveUser);
            }
        }
    }

    static long init() throws SQLException {
        ELogHandler.init();
        return System.identityHashCode(Thread.currentThread());
    }

    private static native void _setUser(AclId var0);
}

