/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.SQLException;

public class BlobValue
extends InputStream
implements Blob {
    private long m_markPos;
    private final long m_nBytes;
    private final InputStream m_stream;
    private long m_streamPos;

    public static int getStreamLength(InputStream value) throws SQLException {
        try {
            value.mark(Integer.MAX_VALUE);
            long length = value.skip(Long.MAX_VALUE);
            if (length > Integer.MAX_VALUE) {
                throw new SQLException("stream content too large");
            }
            value.reset();
            return (int)length;
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public BlobValue(byte[] bytes) {
        this(new ByteArrayInputStream(bytes), bytes.length);
    }

    public BlobValue(InputStream stream, long nBytes) {
        this.m_stream = stream;
        this.m_nBytes = nBytes;
        this.m_streamPos = 0L;
        this.m_markPos = 0L;
    }

    public int available() throws IOException {
        return this.m_stream.available();
    }

    public InputStream getBinaryStream() {
        return this;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 0L || length < 0) {
            throw new IllegalArgumentException();
        }
        if (length == 0) {
            return new byte[0];
        }
        if (pos + (long)length > this.m_nBytes) {
            throw new SQLException("Attempt to read beyond end of Blob data");
        }
        long skip = pos - this.m_streamPos;
        if (skip < 0L) {
            throw new SQLException("Cannot position Blob stream backwards");
        }
        try {
            if (skip > 0L) {
                this.skip(skip);
            }
            byte[] buf = new byte[length];
            this.read(buf);
            return buf;
        }
        catch (IOException e) {
            throw new SQLException("Error reading Blob data: " + e.getMessage());
        }
    }

    public void getContents(ByteBuffer buf) throws IOException {
        int rs = 0;
        if (buf.hasArray()) {
            byte[] bytes = buf.array();
            rs = this.m_stream.read(bytes);
        } else {
            int br;
            byte[] trBuf = new byte[1024];
            while ((br = this.m_stream.read(trBuf)) > 0) {
                buf.put(trBuf, 0, br);
                rs += br;
            }
        }
        if ((long)rs != this.m_nBytes) {
            throw new IOException("Not all bytes could be read");
        }
        this.m_streamPos += (long)rs;
    }

    public long length() {
        return this.m_nBytes;
    }

    public synchronized void mark(int readLimit) {
        this.m_stream.mark(readLimit);
        this.m_markPos = this.m_streamPos;
    }

    public boolean markSupported() {
        return this.m_stream.markSupported();
    }

    public long position(Blob pattern, long start) {
        throw new UnsupportedOperationException();
    }

    public long position(byte[] pattern, long start) {
        throw new UnsupportedOperationException();
    }

    public synchronized int read() throws IOException {
        int rs = this.m_stream.read();
        ++this.m_streamPos;
        return rs;
    }

    public synchronized int read(byte[] b) throws IOException {
        int rs = this.m_stream.read(b);
        this.m_streamPos += (long)rs;
        return rs;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int rs = this.m_stream.read(b, off, len);
        this.m_streamPos += (long)rs;
        return rs;
    }

    public synchronized void reset() throws IOException {
        this.m_stream.reset();
        this.m_streamPos = this.m_markPos;
    }

    public OutputStream setBinaryStream(long pos) {
        throw new UnsupportedOperationException();
    }

    public int setBytes(long pos, byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    public synchronized long skip(long nBytes) throws IOException {
        long skipped = this.m_stream.skip(nBytes);
        this.m_streamPos += skipped;
        return skipped;
    }

    public void truncate(long len) {
        throw new UnsupportedOperationException();
    }
}

