/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import org.postgresql.pljava.jdbc.ReadOnlyResultSet;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

abstract class ResultSetBase
extends ReadOnlyResultSet {
    private int m_fetchSize;
    private int m_row;

    ResultSetBase(int fetchSize) {
        this.m_fetchSize = fetchSize;
        this.m_row = 0;
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public final int getFetchSize() throws SQLException {
        return this.m_fetchSize;
    }

    public final int getRow() throws SQLException {
        return this.m_row;
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public void afterLast() throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public void beforeFirst() throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public void close() throws SQLException {
        this.m_row = -1;
    }

    public boolean first() throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public boolean isAfterLast() throws SQLException {
        return this.m_row < 0;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.m_row == 0;
    }

    public boolean isFirst() throws SQLException {
        return this.m_row == 1;
    }

    public boolean last() throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public boolean previous() throws SQLException {
        throw new UnsupportedFeatureException("Reverse positioning");
    }

    public boolean absolute(int row) throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public boolean relative(int rows) throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new UnsupportedFeatureException("Non forward fetch direction");
        }
    }

    public void setFetchSize(int fetchSize) throws SQLException {
        if (fetchSize <= 0) {
            throw new IllegalArgumentException("Illegal fetch size for ResultSet");
        }
        this.m_fetchSize = fetchSize;
    }

    final void setRow(int row) {
        this.m_row = row;
    }
}

