/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.internal.PgSavepoint;
import org.postgresql.pljava.jdbc.Invocation;
import org.postgresql.pljava.jdbc.SPIDatabaseMetaData;
import org.postgresql.pljava.jdbc.SPIPreparedStatement;
import org.postgresql.pljava.jdbc.SPIStatement;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIConnection
implements Connection {
    private static final HashMap s_sqlType2Class = new HashMap(30);
    private int[] VERSION_NUMBER = null;
    public static final String[] JDBC3_TYPE_NAMES;
    public static final int[] JDBC_TYPE_NUMBERS;

    private static final void addType(Class clazz, int sqlType) {
        s_sqlType2Class.put(clazz, new Integer(sqlType));
    }

    public static Connection getDefault() throws SQLException {
        return new SPIConnection();
    }

    public int getHoldability() {
        return 2;
    }

    public int getTransactionIsolation() {
        return 2;
    }

    public void clearWarnings() throws SQLException {
        throw new UnsupportedFeatureException("Connection.clearWarnings");
    }

    public void close() {
    }

    public void commit() throws SQLException {
        throw new UnsupportedFeatureException("Connection.commit");
    }

    public void rollback() throws SQLException {
        throw new UnsupportedFeatureException("Connection.rollback");
    }

    public boolean getAutoCommit() {
        return false;
    }

    public boolean isClosed() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setHoldability(int holdability) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setHoldability");
    }

    public void setTransactionIsolation(int level) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setTransactionIsolation");
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setAutoCommit");
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setReadOnly");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCatalog() throws SQLException {
        ResultSet rs = this.createStatement().executeQuery("SELECT pg_catalog.current_database()");
        try {
            rs.next();
            String string = rs.getString(1);
            return string;
        }
        finally {
            rs.close();
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setCatalog");
    }

    public DatabaseMetaData getMetaData() {
        return new SPIDatabaseMetaData(this);
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedFeatureException("Connection.getWarnings");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof PgSavepoint)) {
            throw new IllegalArgumentException("Not a PL/Java Savepoint");
        }
        PgSavepoint sp = (PgSavepoint)savepoint;
        sp.release();
        SPIConnection.forgetSavepoint(sp);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof PgSavepoint)) {
            throw new IllegalArgumentException("Not a PL/Java Savepoint");
        }
        PgSavepoint sp = (PgSavepoint)savepoint;
        Invocation.clearErrorCondition();
        sp.rollback();
        SPIConnection.forgetSavepoint(sp);
    }

    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
        return new SPIStatement(this);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType != 1003) {
            throw new UnsupportedOperationException("TYPE_FORWARD_ONLY supported ResultSet type");
        }
        if (resultSetConcurrency != 1007) {
            throw new UnsupportedOperationException("CONCUR_READ_ONLY is the supported ResultSet concurrency");
        }
        return this.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 2) {
            throw new UnsupportedOperationException("CLOSE_CURSORS_AT_COMMIT is the only supported ResultSet holdability");
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    public Map getTypeMap() throws SQLException {
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new UnsupportedOperationException("Type map is not yet implemented");
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.nativeSQL(sql, null);
    }

    public String nativeSQL(String sql, int[] paramCountRet) {
        StringBuffer buf = new StringBuffer();
        int len = sql.length();
        int inQuote = 0;
        int paramIndex = 1;
        block5: for (int idx = 0; idx < len; ++idx) {
            int c = sql.charAt(idx);
            switch (c) {
                case 92: {
                    buf.append((char)c);
                    if (++idx == len) break;
                    c = sql.charAt(idx);
                    break;
                }
                case 34: 
                case 39: {
                    if (inQuote == c) {
                        inQuote = 0;
                        break;
                    }
                    inQuote = c;
                    break;
                }
                case 63: {
                    if (inQuote != 0) break;
                    buf.append('$');
                    buf.append(paramIndex++);
                    continue block5;
                }
                default: {
                    if (inQuote != 0 || !Character.isWhitespace((char)c)) break;
                    ++idx;
                    while (idx < len && Character.isWhitespace(sql.charAt(idx))) {
                        ++idx;
                    }
                    --idx;
                    c = 32;
                }
            }
            buf.append((char)c);
        }
        if (paramCountRet != null) {
            paramCountRet[0] = paramIndex - 1;
        }
        return buf.toString();
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new UnsupportedOperationException("Procedure calls are not yet implemented");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException("Procedure calls are not yet implemented");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("Procedure calls are not yet implemented");
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
        int[] pcount = new int[]{0};
        sql = this.nativeSQL(sql, pcount);
        SPIPreparedStatement stmt = new SPIPreparedStatement(this, sql, pcount[0]);
        Invocation.current().manageStatement(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType != 1003) {
            throw new UnsupportedOperationException("TYPE_FORWARD_ONLY supported ResultSet type");
        }
        if (resultSetConcurrency != 1007) {
            throw new UnsupportedOperationException("CONCUR_READ_ONLY is the supported ResultSet concurrency");
        }
        return this.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 2) {
            throw new UnsupportedOperationException("CLOSE_CURSORS_AT_COMMIT is the only supported ResultSet holdability");
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.rememberSavepoint(PgSavepoint.set("anonymous_savepoint"));
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.rememberSavepoint(PgSavepoint.set(name));
    }

    static int getTypeForClass(Class c) {
        if (c.isArray() && !c.equals([B.class)) {
            return 2003;
        }
        Integer sqt = (Integer)s_sqlType2Class.get(c);
        if (sqt != null) {
            return sqt;
        }
        return 1111;
    }

    private Savepoint rememberSavepoint(PgSavepoint sp) throws SQLException {
        Invocation invocation = Invocation.current();
        PgSavepoint old = invocation.getSavepoint();
        if (old == null) {
            invocation.setSavepoint(sp);
        }
        return sp;
    }

    private static void forgetSavepoint(PgSavepoint sp) throws SQLException {
        Invocation invocation = Invocation.current();
        if (invocation.getSavepoint() == sp) {
            invocation.setSavepoint(null);
        }
    }

    public int[] getVersionNumber() throws SQLException {
        if (this.VERSION_NUMBER != null) {
            return this.VERSION_NUMBER;
        }
        ResultSet rs = this.createStatement().executeQuery("SELECT version()");
        try {
            if (!rs.next()) {
                throw new SQLException("Cannot retrieve product version number");
            }
            String ver = rs.getString(1);
            Pattern p = Pattern.compile("^PostgreSQL\\s+(\\d+)\\.(\\d+)(.\\d+)?.*");
            Matcher m = p.matcher(ver);
            if (m.matches()) {
                this.VERSION_NUMBER = new int[3];
                this.VERSION_NUMBER[0] = Integer.parseInt(m.group(1));
                this.VERSION_NUMBER[1] = Integer.parseInt(m.group(2));
                String bugfix = m.group(3);
                if (bugfix != null && bugfix.length() > 1) {
                    this.VERSION_NUMBER[2] = Integer.parseInt(bugfix.substring(1));
                }
                int[] nArray = this.VERSION_NUMBER;
                return nArray;
            }
            try {
                throw new SQLException("Unexpected product version string format: " + ver);
            }
            catch (PatternSyntaxException e) {
                throw new SQLException("Error in product version string parsing: " + e.getMessage());
            }
        }
        finally {
            rs.close();
        }
    }

    public int getSQLType(String pgTypeName) {
        if (pgTypeName == null) {
            return 1111;
        }
        for (int i = 0; i < JDBC3_TYPE_NAMES.length; ++i) {
            if (!pgTypeName.equals(JDBC3_TYPE_NAMES[i])) continue;
            return JDBC_TYPE_NUMBERS[i];
        }
        return 1111;
    }

    public int getSQLType(Oid oid) throws SQLException {
        return this.getSQLType(this.getPGType(oid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPGType(Oid oid) throws SQLException {
        String typeName;
        block5: {
            typeName = null;
            PreparedStatement query = null;
            ResultSet rs = null;
            try {
                query = this.prepareStatement("SELECT typname FROM pg_catalog.pg_type WHERE oid=?");
                query.setObject(1, oid);
                rs = query.executeQuery();
                if (rs.next()) {
                    typeName = rs.getString(1);
                    break block5;
                }
                throw new SQLException("Cannot find PG type with oid=" + oid);
            }
            finally {
                if (query != null) {
                    query.close();
                }
            }
        }
        return typeName;
    }

    static Object basicCoersion(Class cls, Object value) throws SQLException {
        if (value == null || cls.isInstance(value)) {
            return value;
        }
        if (cls == String.class) {
            if (value instanceof Number || value instanceof Boolean || value instanceof Timestamp || value instanceof Date || value instanceof Time) {
                return value.toString();
            }
        } else if (cls == URL.class && value instanceof String) {
            try {
                return new URL((String)value);
            }
            catch (MalformedURLException e) {
                throw new SQLException(e.toString());
            }
        }
        throw new SQLException("Cannot derive a value of class " + cls.getName() + " from an object of class " + value.getClass().getName());
    }

    static Number basicNumericCoersion(Class cls, Object value) throws SQLException {
        if (value == null || value instanceof Number) {
            return (Number)value;
        }
        if (cls == Integer.TYPE || cls == Long.TYPE || cls == Short.TYPE || cls == Byte.TYPE) {
            if (value instanceof String) {
                return Long.valueOf((String)value);
            }
            if (value instanceof Boolean) {
                return new Long((Boolean)value != false ? 1L : 0L);
            }
        } else if (cls == BigDecimal.class) {
            if (value instanceof String) {
                return new BigDecimal((String)value);
            }
            if (value instanceof Boolean) {
                return new BigDecimal((Boolean)value != false ? 1 : 0);
            }
        }
        if (cls == Double.TYPE || cls == Float.TYPE) {
            if (value instanceof String) {
                return Double.valueOf((String)value);
            }
            if (value instanceof Boolean) {
                return new Double((Boolean)value != false ? 1.0 : 0.0);
            }
        }
        throw new SQLException("Cannot derive a Number from an object of class " + value.getClass().getName());
    }

    static Object basicCalendricalCoersion(Class cls, Object value, Calendar cal) throws SQLException {
        if (value == null) {
            return value;
        }
        if (cls.isInstance(value)) {
            return value;
        }
        if (cls == Timestamp.class) {
            if (value instanceof Date) {
                cal.setTime((Date)value);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                return new Timestamp(cal.getTimeInMillis());
            }
            if (value instanceof Time) {
                cal.setTime((Date)value);
                cal.set(1970, 0, 1);
                return new Timestamp(cal.getTimeInMillis());
            }
            if (value instanceof String) {
                return Timestamp.valueOf((String)value);
            }
        } else if (cls == Date.class) {
            if (value instanceof Timestamp) {
                Timestamp ts = (Timestamp)value;
                cal.setTime(ts);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                return new Date(cal.getTimeInMillis());
            }
            if (value instanceof String) {
                return Date.valueOf((String)value);
            }
        } else if (cls == Time.class) {
            if (value instanceof Timestamp) {
                Timestamp ts = (Timestamp)value;
                cal.setTime(ts);
                cal.set(1970, 0, 1);
                return new Time(cal.getTimeInMillis());
            }
            if (value instanceof String) {
                return Time.valueOf((String)value);
            }
        }
        throw new SQLException("Cannot derive a value of class " + cls.getName() + " from an object of class " + value.getClass().getName());
    }

    static {
        SPIConnection.addType(String.class, 12);
        SPIConnection.addType(Byte.class, -6);
        SPIConnection.addType(Short.class, 5);
        SPIConnection.addType(Integer.class, 4);
        SPIConnection.addType(Long.class, -5);
        SPIConnection.addType(Float.class, 6);
        SPIConnection.addType(Double.class, 8);
        SPIConnection.addType(BigDecimal.class, 3);
        SPIConnection.addType(BigInteger.class, 2);
        SPIConnection.addType(Boolean.class, 16);
        SPIConnection.addType(Blob.class, 2004);
        SPIConnection.addType(Clob.class, 2005);
        SPIConnection.addType(Date.class, 91);
        SPIConnection.addType(Time.class, 92);
        SPIConnection.addType(Timestamp.class, 93);
        SPIConnection.addType(java.util.Date.class, 93);
        SPIConnection.addType([B.class, -3);
        SPIConnection.addType(BitSet.class, -7);
        SPIConnection.addType(URL.class, 70);
        JDBC3_TYPE_NAMES = new String[]{"int2", "int4", "oid", "int8", "cash", "money", "numeric", "float4", "float8", "bpchar", "char", "char2", "char4", "char8", "char16", "varchar", "text", "name", "filename", "bytea", "bool", "bit", "date", "time", "timetz", "abstime", "timestamp", "timestamptz", "_bool", "_char", "_int2", "_int4", "_text", "_oid", "_varchar", "_int8", "_float4", "_float8", "_abstime", "_date", "_time", "_timestamp", "_numeric", "_bytea"};
        JDBC_TYPE_NUMBERS = new int[]{5, 4, 4, -5, 8, 8, 2, 7, 8, 1, 1, 1, 1, 1, 1, 12, 12, 12, 12, -2, -7, -7, 91, 92, 92, 93, 93, 93, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003};
    }
}

