/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.postgresql.pljava.internal.AclId;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.ResultSetField;
import org.postgresql.pljava.jdbc.SPIConnection;
import org.postgresql.pljava.jdbc.SPIDriver;
import org.postgresql.pljava.jdbc.SyntheticResultSet;
import org.postgresql.pljava.jdbc.TypeOid;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIDatabaseMetaData
implements DatabaseMetaData {
    private static final String KEYWORDS = "abort,acl,add,aggregate,append,archive,arch_store,backward,binary,boolean,change,cluster,copy,database,delimiter,delimiters,do,extend,explain,forward,heavy,index,inherits,isnull,light,listen,load,merge,nothing,notify,notnull,oids,purge,rename,replace,retrieve,returns,rule,recipe,setof,stdin,stdout,store,vacuum,verbose,version";
    private final SPIConnection m_connection;
    private static final int VARHDRSZ = 4;
    private int NAMEDATALEN = 0;
    private int INDEX_MAX_KEYS = 0;
    private static final HashMap s_tableTypeClauses = new HashMap();
    private static final String[] s_defaultTableTypes;

    public SPIDatabaseMetaData(SPIConnection conn) {
        this.m_connection = conn;
    }

    protected int getMaxIndexKeys() throws SQLException {
        if (this.INDEX_MAX_KEYS == 0) {
            this.INDEX_MAX_KEYS = Integer.parseInt(Backend.getConfigOption("max_index_keys"));
        }
        return this.INDEX_MAX_KEYS;
    }

    protected int getMaxNameLength() throws SQLException {
        if (this.NAMEDATALEN == 0) {
            String sql = "SELECT t.typlen FROM pg_catalog.pg_type t, pg_catalog.pg_namespace n WHERE t.typnamespace=n.oid   AND t.typname='name'   AND n.nspname='pg_catalog'";
            ResultSet rs = this.m_connection.createStatement().executeQuery(sql);
            if (!rs.next()) {
                throw new SQLException("Unable to find name datatype in the system catalogs.");
            }
            this.NAMEDATALEN = rs.getInt("typlen");
            rs.close();
        }
        return this.NAMEDATALEN - 1;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        return "jdbc:default:connection";
    }

    public String getUserName() throws SQLException {
        return AclId.getUser().getName();
    }

    public boolean isReadOnly() throws SQLException {
        return this.m_connection.isReadOnly();
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "PostgreSQL";
    }

    public String getDatabaseProductVersion() throws SQLException {
        int[] ver = this.m_connection.getVersionNumber();
        return ver[0] + "." + ver[1] + "." + ver[2];
    }

    public String getDriverName() throws SQLException {
        return "PostgreSQL pljava SPI Driver";
    }

    public String getDriverVersion() throws SQLException {
        SPIDriver d = new SPIDriver();
        return d.getMajorVersion() + "." + d.getMinorVersion();
    }

    public int getDriverMajorVersion() {
        return new SPIDriver().getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return new SPIDriver().getMinorVersion();
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return KEYWORDS;
    }

    public String getNumericFunctions() throws SQLException {
        return "abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,radians,rand,round,sign,sin,sqrt,tan,truncate";
    }

    public String getStringFunctions() throws SQLException {
        String funcs = "ascii,char,concat,lcase,left,length,ltrim,repeat,rtrim,space,substring,ucase,replace";
        return funcs;
    }

    public String getSystemFunctions() throws SQLException {
        return "database,ifnull,user";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "curdate,curtime,dayname,dayofmonth,dayofweek,dayofyear,hour,minute,month,monthname,now,quarter,second,week,year";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    public String getProcedureTerm() throws SQLException {
        return "function";
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.getMaxIndexKeys();
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 1600;
    }

    public int getMaxConnections() throws SQLException {
        return 8192;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxRowSize() throws SQLException {
        return 0x40000000;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 1;
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        if (level == 8 || level == 2) {
            return true;
        }
        return this.getDatabaseMajorVersion() >= 8 && (level == 1 || level == 4);
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    private static String escapeQuotes(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int length = s.length();
        int prevChar = 32;
        int prevPrevChar = 32;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            sb.append(c);
            if (c == '\'' && (prevChar != 92 || prevChar == 92 && prevPrevChar == 92)) {
                sb.append("'");
            }
            prevPrevChar = prevChar;
            prevChar = c;
        }
        return sb.toString();
    }

    private static String resolveSchemaConditionWithOperator(String expr, String schema, String operator) {
        if (schema == null) {
            return "1=1";
        }
        if (!"".equals(schema)) {
            return expr + " " + operator + " '" + SPIDatabaseMetaData.escapeQuotes(schema) + "' ";
        }
        return expr + " " + operator + " 'public' ";
    }

    private static String resolveSchemaCondition(String expr, String schema) {
        return SPIDatabaseMetaData.resolveSchemaConditionWithOperator(expr, schema, "=");
    }

    private static String resolveSchemaPatternCondition(String expr, String schema) {
        return SPIDatabaseMetaData.resolveSchemaConditionWithOperator(expr, schema, "LIKE");
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String sql = "SELECT NULL AS PROCEDURE_CAT, n.nspname AS PROCEDURE_SCHEM, p.proname AS PROCEDURE_NAME, NULL, NULL, NULL, d.description AS REMARKS, 2 AS PROCEDURE_TYPE  FROM pg_catalog.pg_namespace n, pg_catalog.pg_proc p  LEFT JOIN pg_catalog.pg_description d ON (p.oid=d.objoid)  LEFT JOIN pg_catalog.pg_class c ON (d.classoid=c.oid AND c.relname='pg_proc')  LEFT JOIN pg_catalog.pg_namespace pn ON (c.relnamespace=pn.oid AND pn.nspname='pg_catalog')  WHERE p.pronamespace=n.oid  AND " + SPIDatabaseMetaData.resolveSchemaPatternCondition("n.nspname", schemaPattern);
        if (procedureNamePattern != null) {
            sql = sql + " AND p.proname LIKE '" + SPIDatabaseMetaData.escapeQuotes(procedureNamePattern) + "' ";
        }
        sql = sql + " ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME ";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        ResultSetField[] f = new ResultSetField[13];
        ArrayList<Object[]> v = new ArrayList<Object[]>();
        f[0] = new ResultSetField("PROCEDURE_CAT", TypeOid.VARCHAR, this.getMaxNameLength());
        f[1] = new ResultSetField("PROCEDURE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength());
        f[2] = new ResultSetField("PROCEDURE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[3] = new ResultSetField("COLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[4] = new ResultSetField("COLUMN_TYPE", TypeOid.INT2, 2);
        f[5] = new ResultSetField("DATA_TYPE", TypeOid.INT2, 2);
        f[6] = new ResultSetField("TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[7] = new ResultSetField("PRECISION", TypeOid.INT4, 4);
        f[8] = new ResultSetField("LENGTH", TypeOid.INT4, 4);
        f[9] = new ResultSetField("SCALE", TypeOid.INT2, 2);
        f[10] = new ResultSetField("RADIX", TypeOid.INT2, 2);
        f[11] = new ResultSetField("NULLABLE", TypeOid.INT2, 2);
        f[12] = new ResultSetField("REMARKS", TypeOid.VARCHAR, this.getMaxNameLength());
        String sql = "SELECT n.nspname,p.proname,p.prorettype,p.proargtypes, t.typtype::varchar,t.typrelid  FROM pg_catalog.pg_proc p,pg_catalog.pg_namespace n, pg_catalog.pg_type t  WHERE p.pronamespace=n.oid AND p.prorettype=t.oid  AND " + SPIDatabaseMetaData.resolveSchemaPatternCondition("n.nspname", schemaPattern);
        if (procedureNamePattern != null) {
            sql = sql + " AND p.proname LIKE '" + SPIDatabaseMetaData.escapeQuotes(procedureNamePattern) + "' ";
        }
        sql = sql + " ORDER BY n.nspname, p.proname ";
        ResultSet rs = this.m_connection.createStatement().executeQuery(sql);
        String schema = null;
        String procedureName = null;
        Oid returnType = null;
        String returnTypeType = null;
        Oid returnTypeRelid = null;
        Oid[] argTypes = null;
        while (rs.next()) {
            schema = rs.getString("nspname");
            procedureName = rs.getString("proname");
            returnType = (Oid)rs.getObject("prorettype");
            returnTypeType = rs.getString("typtype");
            returnTypeRelid = (Oid)rs.getObject("typrelid");
            argTypes = (Oid[])rs.getObject("proargtypes");
            if (!returnTypeType.equals("c")) {
                Object[] tuple = new Object[]{null, schema, procedureName, "returnValue", new Short(5), new Short((short)this.m_connection.getSQLType(returnType)), this.m_connection.getPGType(returnType), null, null, null, null, new Short(2), null};
                v.add(tuple);
            }
            for (int i = 0; i < argTypes.length; ++i) {
                Oid argOid = argTypes[i];
                Object[] tuple = new Object[]{null, schema, procedureName, "$" + (i + 1), new Short(1), new Short((short)this.m_connection.getSQLType(argOid)), this.m_connection.getPGType(argOid), null, null, null, null, new Short(2), null};
                v.add(tuple);
            }
            if (!returnTypeType.equals("c")) continue;
            String columnsql = "SELECT a.attname,a.atttypid FROM pg_catalog.pg_attribute a WHERE a.attrelid = ? ORDER BY a.attnum ";
            PreparedStatement stmt = this.m_connection.prepareStatement(columnsql);
            stmt.setObject(1, returnTypeRelid);
            ResultSet columnrs = stmt.executeQuery(columnsql);
            while (columnrs.next()) {
                Oid columnTypeOid = (Oid)columnrs.getObject("atttypid");
                Object[] tuple = new Object[]{null, schema, procedureName, columnrs.getString("attname"), new Short(3), new Short((short)this.m_connection.getSQLType(columnTypeOid)), this.m_connection.getPGType(columnTypeOid), null, null, null, null, new Short(2), null};
                v.add(tuple);
            }
            columnrs.close();
            stmt.close();
        }
        rs.close();
        return this.createSyntheticResultSet(f, v);
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String useSchemas = "SCHEMAS";
        String select = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, c.relname AS TABLE_NAME,  CASE n.nspname LIKE 'pg!_%' ESCAPE '!' OR n.nspname = 'information_schema'  WHEN true THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN CASE c.relkind   WHEN 'r' THEN 'SYSTEM TABLE'   WHEN 'v' THEN 'SYSTEM VIEW'   WHEN 'i' THEN 'SYSTEM INDEX'   ELSE NULL   END  WHEN n.nspname = 'pg_toast' THEN CASE c.relkind   WHEN 'r' THEN 'SYSTEM TOAST TABLE'   WHEN 'i' THEN 'SYSTEM TOAST INDEX'   ELSE NULL   END  ELSE CASE c.relkind   WHEN 'r' THEN 'TEMPORARY TABLE'   WHEN 'i' THEN 'TEMPORARY INDEX'   ELSE NULL   END  END  WHEN false THEN CASE c.relkind  WHEN 'r' THEN 'TABLE'  WHEN 'i' THEN 'INDEX'  WHEN 'S' THEN 'SEQUENCE'  WHEN 'v' THEN 'VIEW'  ELSE NULL  END  ELSE NULL  END  AS TABLE_TYPE, d.description AS REMARKS  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c  LEFT JOIN pg_catalog.pg_description d ON (c.oid = d.objoid AND d.objsubid = 0)  LEFT JOIN pg_catalog.pg_class dc ON (d.classoid=dc.oid AND dc.relname='pg_class')  LEFT JOIN pg_catalog.pg_namespace dn ON (dn.oid=dc.relnamespace AND dn.nspname='pg_catalog')  WHERE c.relnamespace = n.oid  AND " + SPIDatabaseMetaData.resolveSchemaPatternCondition("n.nspname", schemaPattern);
        String orderby = " ORDER BY TABLE_TYPE,TABLE_SCHEM,TABLE_NAME ";
        if (types == null) {
            types = s_defaultTableTypes;
        }
        if (tableNamePattern != null) {
            select = select + " AND c.relname LIKE '" + SPIDatabaseMetaData.escapeQuotes(tableNamePattern) + "' ";
        }
        String sql = select;
        sql = sql + " AND (false ";
        for (int i = 0; i < types.length; ++i) {
            HashMap clauses = (HashMap)s_tableTypeClauses.get(types[i]);
            if (clauses == null) continue;
            String clause = (String)clauses.get(useSchemas);
            sql = sql + " OR ( " + clause + " ) ";
        }
        sql = sql + ") ";
        sql = sql + orderby;
        return this.createMetaDataStatement().executeQuery(sql);
    }

    public ResultSet getSchemas() throws SQLException {
        String sql = "SELECT nspname AS TABLE_SCHEM FROM pg_catalog.pg_namespace WHERE nspname <> 'pg_toast' AND nspname NOT LIKE 'pg!_temp!_%' ESCAPE '!' ORDER BY TABLE_SCHEM";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    public ResultSet getCatalogs() throws SQLException {
        String sql = "SELECT datname AS TABLE_CAT FROM pg_catalog.pg_database ORDER BY TABLE_CAT";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    public ResultSet getTableTypes() throws SQLException {
        String[] types = s_tableTypeClauses.keySet().toArray(new String[s_tableTypeClauses.size()]);
        SPIDatabaseMetaData.sortStringArray(types);
        ResultSetField[] f = new ResultSetField[1];
        ArrayList<Object[]> v = new ArrayList<Object[]>();
        f[0] = new ResultSetField(new String("TABLE_TYPE"), TypeOid.VARCHAR, this.getMaxNameLength());
        for (int i = 0; i < types.length; ++i) {
            Object[] tuple = new Object[]{types[i]};
            v.add(tuple);
        }
        return this.createSyntheticResultSet(f, v);
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ArrayList<Object[]> v = new ArrayList<Object[]>();
        ResultSetField[] f = new ResultSetField[]{new ResultSetField("TABLE_CAT", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("TABLE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("TABLE_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("COLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("DATA_TYPE", TypeOid.INT2, 2), new ResultSetField("TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("COLUMN_SIZE", TypeOid.INT4, 4), new ResultSetField("BUFFER_LENGTH", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("DECIMAL_DIGITS", TypeOid.INT4, 4), new ResultSetField("NUM_PREC_RADIX", TypeOid.INT4, 4), new ResultSetField("NULLABLE", TypeOid.INT4, 4), new ResultSetField("REMARKS", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("COLUMN_DEF", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("SQL_DATA_TYPE", TypeOid.INT4, 4), new ResultSetField("SQL_DATETIME_SUB", TypeOid.INT4, 4), new ResultSetField("CHAR_OCTET_LENGTH", TypeOid.INT4, 4), new ResultSetField("ORDINAL_POSITION", TypeOid.INT4, 4), new ResultSetField("IS_NULLABLE", TypeOid.VARCHAR, this.getMaxNameLength())};
        String sql = "SELECT n.nspname,c.relname,a.attname, a.atttypid as atttypid,a.attnotnull,a.atttypmod, a.attlen::int4 as attlen,a.attnum,def.adsrc,dsc.description  FROM pg_catalog.pg_namespace n  JOIN pg_catalog.pg_class c ON (c.relnamespace = n.oid)  JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid)  LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum)  LEFT JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)  LEFT JOIN pg_catalog.pg_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class')  LEFT JOIN pg_catalog.pg_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='pg_catalog')  WHERE a.attnum > 0 AND NOT a.attisdropped  AND " + SPIDatabaseMetaData.resolveSchemaPatternCondition("n.nspname", schemaPattern);
        if (tableNamePattern != null && !"".equals(tableNamePattern)) {
            sql = sql + " AND c.relname LIKE '" + SPIDatabaseMetaData.escapeQuotes(tableNamePattern) + "' ";
        }
        if (columnNamePattern != null && !"".equals(columnNamePattern)) {
            sql = sql + " AND a.attname LIKE '" + SPIDatabaseMetaData.escapeQuotes(columnNamePattern) + "' ";
        }
        sql = sql + " ORDER BY nspname,relname,attnum ";
        ResultSet rs = this.m_connection.createStatement().executeQuery(sql);
        while (rs.next()) {
            Object[] tuple = new Object[18];
            Oid typeOid = (Oid)rs.getObject("atttypid");
            tuple[0] = null;
            tuple[1] = rs.getString("nspname");
            tuple[2] = rs.getString("relname");
            tuple[3] = rs.getString("attname");
            tuple[4] = new Short((short)this.m_connection.getSQLType(typeOid));
            String pgType = this.m_connection.getPGType(typeOid);
            tuple[5] = this.m_connection.getPGType(typeOid);
            String defval = rs.getString("adsrc");
            if (defval != null) {
                if (pgType.equals("int4")) {
                    if (defval.indexOf("nextval(") != -1) {
                        tuple[5] = "serial";
                    }
                } else if (pgType.equals("int8") && defval.indexOf("nextval(") != -1) {
                    tuple[5] = "bigserial";
                }
            }
            tuple[8] = new Integer(0);
            if (pgType.equals("bpchar") || pgType.equals("varchar")) {
                int atttypmod = rs.getInt("atttypmod");
                tuple[6] = new Integer(atttypmod != -1 ? atttypmod - 4 : 0);
            } else if (pgType.equals("numeric") || pgType.equals("decimal")) {
                int attypmod = rs.getInt("atttypmod") - 4;
                tuple[6] = new Integer(attypmod >> 16 & 0xFFFF);
                tuple[8] = new Integer(attypmod & 0xFFFF);
                tuple[9] = new Integer(10);
            } else if (pgType.equals("bit") || pgType.equals("varbit")) {
                tuple[6] = rs.getObject("atttypmod");
                tuple[9] = new Integer(2);
            } else {
                tuple[6] = rs.getObject("attlen");
                tuple[9] = new Integer(10);
            }
            tuple[7] = null;
            tuple[10] = new Integer(rs.getBoolean("attnotnull") ? 0 : 1);
            tuple[11] = rs.getString("description");
            tuple[12] = rs.getString("adsrc");
            tuple[13] = null;
            tuple[14] = null;
            tuple[15] = tuple[6];
            tuple[16] = new Integer(rs.getInt("attnum"));
            tuple[17] = rs.getBoolean("attnotnull") ? "NO" : "YES";
            v.add(tuple);
        }
        rs.close();
        return this.createSyntheticResultSet(f, v);
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        ResultSetField[] f = new ResultSetField[8];
        ArrayList<Object[]> v = new ArrayList<Object[]>();
        if (table == null) {
            table = "%";
        }
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        f[0] = new ResultSetField("TABLE_CAT", TypeOid.VARCHAR, this.getMaxNameLength());
        f[1] = new ResultSetField("TABLE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength());
        f[2] = new ResultSetField("TABLE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[3] = new ResultSetField("COLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[4] = new ResultSetField("GRANTOR", TypeOid.VARCHAR, this.getMaxNameLength());
        f[5] = new ResultSetField("GRANTEE", TypeOid.VARCHAR, this.getMaxNameLength());
        f[6] = new ResultSetField("PRIVILEGE", TypeOid.VARCHAR, this.getMaxNameLength());
        f[7] = new ResultSetField("IS_GRANTABLE", TypeOid.VARCHAR, this.getMaxNameLength());
        String sql = "SELECT n.nspname,c.relname,u.usename,c.relacl,a.attname  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c, pg_catalog.pg_user u, pg_catalog.pg_attribute a  WHERE c.relnamespace = n.oid  AND u.usesysid = c.relowner  AND c.oid = a.attrelid  AND c.relkind = 'r'  AND a.attnum > 0 AND NOT a.attisdropped  AND " + SPIDatabaseMetaData.resolveSchemaCondition("n.nspname", schema);
        sql = sql + " AND c.relname = '" + SPIDatabaseMetaData.escapeQuotes(table) + "' ";
        if (columnNamePattern != null && !"".equals(columnNamePattern)) {
            sql = sql + " AND a.attname LIKE '" + SPIDatabaseMetaData.escapeQuotes(columnNamePattern) + "' ";
        }
        sql = sql + " ORDER BY attname ";
        ResultSet rs = this.m_connection.createStatement().executeQuery(sql);
        String schemaName = null;
        String tableName = null;
        String column = null;
        String owner = null;
        String[] acls = null;
        HashMap permissions = null;
        String[] permNames = null;
        while (rs.next()) {
            schemaName = rs.getString("nspname");
            tableName = rs.getString("relname");
            column = rs.getString("attname");
            owner = rs.getString("usename");
            acls = (String[])rs.getObject("relacl");
            permissions = this.parseACL(acls, owner);
            permNames = permissions.keySet().toArray(new String[permissions.size()]);
            SPIDatabaseMetaData.sortStringArray(permNames);
            for (int i = 0; i < permNames.length; ++i) {
                ArrayList grantees = (ArrayList)permissions.get(permNames[i]);
                for (int j = 0; j < grantees.size(); ++j) {
                    String grantee = (String)grantees.get(j);
                    String grantable = owner.equals(grantee) ? "YES" : "NO";
                    Object[] tuple = new Object[]{null, schemaName, tableName, column, owner, grantee, permNames[i], grantable};
                    v.add(tuple);
                }
            }
        }
        rs.close();
        return this.createSyntheticResultSet(f, v);
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ResultSetField[] f = new ResultSetField[7];
        ArrayList<Object[]> v = new ArrayList<Object[]>();
        f[0] = new ResultSetField("TABLE_CAT", TypeOid.VARCHAR, this.getMaxNameLength());
        f[1] = new ResultSetField("TABLE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength());
        f[2] = new ResultSetField("TABLE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[3] = new ResultSetField("GRANTOR", TypeOid.VARCHAR, this.getMaxNameLength());
        f[4] = new ResultSetField("GRANTEE", TypeOid.VARCHAR, this.getMaxNameLength());
        f[5] = new ResultSetField("PRIVILEGE", TypeOid.VARCHAR, this.getMaxNameLength());
        f[6] = new ResultSetField("IS_GRANTABLE", TypeOid.VARCHAR, this.getMaxNameLength());
        String sql = "SELECT n.nspname,c.relname,u.usename,c.relacl  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c, pg_catalog.pg_user u  WHERE c.relnamespace = n.oid  AND u.usesysid = c.relowner  AND c.relkind = 'r'  AND " + SPIDatabaseMetaData.resolveSchemaPatternCondition("n.nspname", schemaPattern);
        if (tableNamePattern != null && !"".equals(tableNamePattern)) {
            sql = sql + " AND c.relname LIKE '" + SPIDatabaseMetaData.escapeQuotes(tableNamePattern) + "' ";
        }
        sql = sql + " ORDER BY nspname, relname ";
        ResultSet rs = this.m_connection.createStatement().executeQuery(sql);
        String schema = null;
        String table = null;
        String owner = null;
        String[] acls = null;
        HashMap permissions = null;
        String[] permNames = null;
        while (rs.next()) {
            schema = rs.getString("nspname");
            table = rs.getString("relname");
            owner = rs.getString("usename");
            acls = (String[])rs.getObject("relacl");
            permissions = this.parseACL(acls, owner);
            permNames = permissions.keySet().toArray(new String[permissions.size()]);
            SPIDatabaseMetaData.sortStringArray(permNames);
            for (int i = 0; i < permNames.length; ++i) {
                ArrayList grantees = (ArrayList)permissions.get(permNames[i]);
                for (int j = 0; j < grantees.size(); ++j) {
                    String grantee = (String)grantees.get(j);
                    String grantable = owner.equals(grantee) ? "YES" : "NO";
                    Object[] tuple = new Object[]{null, schema, table, owner, grantee, permNames[i], grantable};
                    v.add(tuple);
                }
            }
        }
        rs.close();
        return this.createSyntheticResultSet(f, v);
    }

    private static void sortStringArray(String[] s) {
        for (int i = 0; i < s.length - 1; ++i) {
            for (int j = i + 1; j < s.length; ++j) {
                if (s[i].compareTo(s[j]) <= 0) continue;
                String tmp = s[i];
                s[i] = s[j];
                s[j] = tmp;
            }
        }
    }

    private void addACLPrivileges(String acl, HashMap privileges) {
        int equalIndex = acl.lastIndexOf("=");
        String name = acl.substring(0, equalIndex);
        if (name.length() == 0) {
            name = "PUBLIC";
        }
        String privs = acl.substring(equalIndex + 1);
        for (int i = 0; i < privs.length(); ++i) {
            String sqlpriv;
            char c = privs.charAt(i);
            switch (c) {
                case 'a': {
                    sqlpriv = "INSERT";
                    break;
                }
                case 'r': {
                    sqlpriv = "SELECT";
                    break;
                }
                case 'w': {
                    sqlpriv = "UPDATE";
                    break;
                }
                case 'd': {
                    sqlpriv = "DELETE";
                    break;
                }
                case 'R': {
                    sqlpriv = "RULE";
                    break;
                }
                case 'x': {
                    sqlpriv = "REFERENCES";
                    break;
                }
                case 't': {
                    sqlpriv = "TRIGGER";
                    break;
                }
                case 'X': {
                    sqlpriv = "EXECUTE";
                    break;
                }
                case 'U': {
                    sqlpriv = "USAGE";
                    break;
                }
                case 'C': {
                    sqlpriv = "CREATE";
                    break;
                }
                case 'T': {
                    sqlpriv = "CREATE TEMP";
                    break;
                }
                default: {
                    sqlpriv = "UNKNOWN";
                }
            }
            ArrayList<String> usersWithPermission = (ArrayList<String>)privileges.get(sqlpriv);
            if (usersWithPermission == null) {
                usersWithPermission = new ArrayList<String>();
                privileges.put(sqlpriv, usersWithPermission);
            }
            usersWithPermission.add(name);
        }
    }

    protected HashMap parseACL(String[] aclArray, String owner) {
        if (aclArray == null || aclArray.length == 0) {
            aclArray = new String[]{owner + "=arwdRxt"};
        }
        HashMap privileges = new HashMap();
        for (int i = 0; i < aclArray.length; ++i) {
            String acl = aclArray[i];
            this.addACLPrivileges(acl, privileges);
        }
        return privileges;
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        ResultSetField[] f = new ResultSetField[8];
        ArrayList<Object[]> v = new ArrayList<Object[]>();
        f[0] = new ResultSetField("SCOPE", TypeOid.INT2, 2);
        f[1] = new ResultSetField("COLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[2] = new ResultSetField("DATA_TYPE", TypeOid.INT2, 2);
        f[3] = new ResultSetField("TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[4] = new ResultSetField("COLUMN_SIZE", TypeOid.INT4, 4);
        f[5] = new ResultSetField("BUFFER_LENGTH", TypeOid.INT4, 4);
        f[6] = new ResultSetField("DECIMAL_DIGITS", TypeOid.INT2, 2);
        f[7] = new ResultSetField("PSEUDO_COLUMN", TypeOid.INT2, 2);
        String where = "";
        String from = " FROM pg_catalog.pg_namespace n, pg_catalog.pg_class ct, pg_catalog.pg_class ci, pg_catalog.pg_attribute a, pg_catalog.pg_index i ";
        where = " AND ct.relnamespace = n.oid  AND " + SPIDatabaseMetaData.resolveSchemaCondition("n.nspname", schema);
        String sql = "SELECT a.attname, a.atttypid as atttypid " + from + " WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid " + " AND a.attrelid=ci.oid AND i.indisprimary " + " AND ct.relname = '" + SPIDatabaseMetaData.escapeQuotes(table) + "' " + where + " ORDER BY a.attnum ";
        ResultSet rs = this.m_connection.createStatement().executeQuery(sql);
        while (rs.next()) {
            Object[] tuple = new Object[8];
            Oid columnTypeOid = (Oid)rs.getObject("atttypid");
            tuple[0] = new Short((short)scope);
            tuple[1] = rs.getString("attname");
            tuple[2] = new Short((short)this.m_connection.getSQLType(columnTypeOid));
            tuple[3] = this.m_connection.getPGType(columnTypeOid);
            tuple[4] = null;
            tuple[5] = null;
            tuple[6] = null;
            tuple[7] = new Short(1);
            v.add(tuple);
        }
        return this.createSyntheticResultSet(f, v);
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        ResultSetField[] f = new ResultSetField[8];
        ArrayList<Object[]> v = new ArrayList<Object[]>();
        f[0] = new ResultSetField("SCOPE", TypeOid.INT2, 2);
        f[1] = new ResultSetField("COLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[2] = new ResultSetField("DATA_TYPE", TypeOid.INT2, 2);
        f[3] = new ResultSetField("TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[4] = new ResultSetField("COLUMN_SIZE", TypeOid.INT4, 4);
        f[5] = new ResultSetField("BUFFER_LENGTH", TypeOid.INT4, 4);
        f[6] = new ResultSetField("DECIMAL_DIGITS", TypeOid.INT2, 2);
        f[7] = new ResultSetField("PSEUDO_COLUMN", TypeOid.INT2, 2);
        Object[] tuple = new Object[]{null, "ctid", new Short((short)this.m_connection.getSQLType("tid")), "tid", null, null, null, new Short(2)};
        v.add(tuple);
        return this.createSyntheticResultSet(f, v);
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String where = "";
        String select = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, ";
        String from = " FROM pg_catalog.pg_namespace n, pg_catalog.pg_class ct, pg_catalog.pg_class ci, pg_catalog.pg_attribute a, pg_catalog.pg_index i ";
        where = " AND ct.relnamespace = n.oid AND " + SPIDatabaseMetaData.resolveSchemaCondition("n.nspname", schema);
        String sql = select + " ct.relname AS TABLE_NAME, " + " a.attname AS COLUMN_NAME, " + " a.attnum::int2 AS KEY_SEQ, " + " ci.relname AS PK_NAME " + from + " WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid " + " AND a.attrelid=ci.oid AND i.indisprimary ";
        if (table != null && !"".equals(table)) {
            sql = sql + " AND ct.relname = '" + SPIDatabaseMetaData.escapeQuotes(table) + "' ";
        }
        sql = sql + where + " ORDER BY table_name, pk_name, key_seq";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    protected ResultSet getImportedExportedKeys(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        ResultSetField[] f = new ResultSetField[]{new ResultSetField("PKTABLE_CAT", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("PKTABLE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("PKTABLE_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("PKCOLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("FKTABLE_CAT", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("FKTABLE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("FKTABLE_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("FKCOLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("KEY_SEQ", TypeOid.INT2, 2), new ResultSetField("UPDATE_RULE", TypeOid.INT2, 2), new ResultSetField("DELETE_RULE", TypeOid.INT2, 2), new ResultSetField("FK_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("PK_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("DEFERRABILITY", TypeOid.INT2, 2)};
        String sql = "SELECT NULL::text AS PKTABLE_CAT, pkn.nspname AS PKTABLE_SCHEM, pkc.relname AS PKTABLE_NAME, pka.attname AS PKCOLUMN_NAME, NULL::text AS FKTABLE_CAT, fkn.nspname AS FKTABLE_SCHEM, fkc.relname AS FKTABLE_NAME, fka.attname AS FKCOLUMN_NAME, pos.n::int2 AS KEY_SEQ, CASE con.confupdtype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'a' THEN 3 ELSE NULL END::int2 AS UPDATE_RULE, CASE con.confdeltype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'a' THEN 3 ELSE NULL END::int2 AS DELETE_RULE, con.conname AS FK_NAME, pkic.relname AS PK_NAME, CASE  WHEN con.condeferrable AND con.condeferred THEN 5 WHEN con.condeferrable THEN 6 ELSE 7 END::int2 AS DEFERRABILITY  FROM  pg_catalog.pg_namespace pkn, pg_catalog.pg_class pkc, pg_catalog.pg_attribute pka,  pg_catalog.pg_namespace fkn, pg_catalog.pg_class fkc, pg_catalog.pg_attribute fka,  pg_catalog.pg_constraint con,  pg_catalog.generate_series(1, " + this.getMaxIndexKeys() + ") pos(n), " + " pg_catalog.pg_depend dep, pg_catalog.pg_class pkic " + " WHERE pkn.oid = pkc.relnamespace AND pkc.oid = pka.attrelid AND pka.attnum = con.confkey[pos.n] AND con.confrelid = pkc.oid " + " AND fkn.oid = fkc.relnamespace AND fkc.oid = fka.attrelid AND fka.attnum = con.conkey[pos.n] AND con.conrelid = fkc.oid " + " AND con.contype = 'f' AND con.oid = dep.objid AND pkic.oid = dep.refobjid AND pkic.relkind = 'i' AND dep.classid = 'pg_constraint'::regclass::oid AND dep.refclassid = 'pg_class'::regclass::oid " + " AND " + SPIDatabaseMetaData.resolveSchemaCondition("pkn.nspname", primarySchema) + " AND " + SPIDatabaseMetaData.resolveSchemaCondition("fkn.nspname", foreignSchema);
        if (primaryTable != null && !"".equals(primaryTable)) {
            sql = sql + " AND pkc.relname = '" + SPIDatabaseMetaData.escapeQuotes(primaryTable) + "' ";
        }
        if (foreignTable != null && !"".equals(foreignTable)) {
            sql = sql + " AND fkc.relname = '" + SPIDatabaseMetaData.escapeQuotes(foreignTable) + "' ";
        }
        sql = primaryTable != null ? sql + " ORDER BY fkn.nspname,fkc.relname,pos.n" : sql + " ORDER BY pkn.nspname,pkc.relname,pos.n";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getImportedExportedKeys(null, null, null, catalog, schema, table);
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getImportedExportedKeys(catalog, schema, table, null, null, null);
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getImportedExportedKeys(primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
    }

    public ResultSet getTypeInfo() throws SQLException {
        ResultSetField[] f = new ResultSetField[18];
        ArrayList<Object[]> v = new ArrayList<Object[]>();
        f[0] = new ResultSetField("TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[1] = new ResultSetField("DATA_TYPE", TypeOid.INT2, 2);
        f[2] = new ResultSetField("PRECISION", TypeOid.INT4, 4);
        f[3] = new ResultSetField("LITERAL_PREFIX", TypeOid.VARCHAR, this.getMaxNameLength());
        f[4] = new ResultSetField("LITERAL_SUFFIX", TypeOid.VARCHAR, this.getMaxNameLength());
        f[5] = new ResultSetField("CREATE_PARAMS", TypeOid.VARCHAR, this.getMaxNameLength());
        f[6] = new ResultSetField("NULLABLE", TypeOid.INT2, 2);
        f[7] = new ResultSetField("CASE_SENSITIVE", TypeOid.BOOL, 1);
        f[8] = new ResultSetField("SEARCHABLE", TypeOid.INT2, 2);
        f[9] = new ResultSetField("UNSIGNED_ATTRIBUTE", TypeOid.BOOL, 1);
        f[10] = new ResultSetField("FIXED_PREC_SCALE", TypeOid.BOOL, 1);
        f[11] = new ResultSetField("AUTO_INCREMENT", TypeOid.BOOL, 1);
        f[12] = new ResultSetField("LOCAL_TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        f[13] = new ResultSetField("MINIMUM_SCALE", TypeOid.INT2, 2);
        f[14] = new ResultSetField("MAXIMUM_SCALE", TypeOid.INT2, 2);
        f[15] = new ResultSetField("SQL_DATA_TYPE", TypeOid.INT4, 4);
        f[16] = new ResultSetField("SQL_DATETIME_SUB", TypeOid.INT4, 4);
        f[17] = new ResultSetField("NUM_PREC_RADIX", TypeOid.INT4, 4);
        String sql = "SELECT typname FROM pg_catalog.pg_type where typrelid = 0";
        ResultSet rs = this.m_connection.createStatement().executeQuery(sql);
        Integer i9 = new Integer(9);
        Integer i10 = new Integer(10);
        Short nn = new Short(0);
        Short ts = new Short(3);
        String typname = null;
        while (rs.next()) {
            Object[] tuple1;
            Object[] tuple = new Object[18];
            typname = rs.getString(1);
            tuple[0] = typname;
            tuple[1] = new Short((short)this.m_connection.getSQLType(typname));
            tuple[2] = i9;
            tuple[6] = nn;
            tuple[7] = Boolean.FALSE;
            tuple[8] = ts;
            tuple[9] = Boolean.FALSE;
            tuple[10] = Boolean.FALSE;
            tuple[11] = Boolean.FALSE;
            tuple[17] = i10;
            v.add(tuple);
            if (typname.equals("int4")) {
                tuple1 = (Object[])tuple.clone();
                tuple1[0] = "serial";
                tuple1[11] = Boolean.TRUE;
                v.add(tuple1);
                continue;
            }
            if (!typname.equals("int8")) continue;
            tuple1 = (Object[])tuple.clone();
            tuple1[0] = "bigserial";
            tuple1[11] = Boolean.TRUE;
            v.add(tuple1);
        }
        rs.close();
        return this.createSyntheticResultSet(f, v);
    }

    public ResultSet getIndexInfo(String catalog, String schema, String tableName, boolean unique, boolean approximate) throws SQLException {
        String select = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, ";
        String from = " FROM pg_catalog.pg_namespace n, pg_catalog.pg_class ct, pg_catalog.pg_class ci, pg_catalog.pg_index i, pg_catalog.pg_attribute a, pg_catalog.pg_am am ";
        String where = " AND n.oid = ct.relnamespace  AND " + SPIDatabaseMetaData.resolveSchemaCondition("n.nspname", schema);
        String sql = select + " ct.relname AS TABLE_NAME, NOT i.indisunique AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, ci.relname AS INDEX_NAME, " + " CASE i.indisclustered " + " WHEN true THEN " + 1 + " ELSE CASE am.amname " + " WHEN 'hash' THEN " + 2 + " ELSE " + 3 + " END " + " END::int2 AS TYPE, " + " a.attnum::int2 AS ORDINAL_POSITION, " + " a.attname AS COLUMN_NAME, " + " NULL AS ASC_OR_DESC, " + " ci.reltuples AS CARDINALITY, " + " ci.relpages AS PAGES, " + " NULL AS FILTER_CONDITION " + from + " WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid AND a.attrelid=ci.oid AND ci.relam=am.oid " + where + " AND ct.relname = '" + SPIDatabaseMetaData.escapeQuotes(tableName) + "' ";
        if (unique) {
            sql = sql + " AND i.indisunique ";
        }
        sql = sql + " ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION ";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (type != 1003) {
            return false;
        }
        return concurrency == 1007;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return true;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int i) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int i) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String sql = "select null as type_cat, n.nspname as type_schem, t.typname as type_name,  null as class_name, CASE WHEN t.typtype='c' then 2002 else 2001 end as data_type, pg_catalog.obj_description(t.oid, 'pg_type')  as remarks, CASE WHEN t.typtype = 'd' then  (select CASE";
        for (int i = 0; i < SPIConnection.JDBC3_TYPE_NAMES.length; ++i) {
            sql = sql + " when typname = '" + SPIConnection.JDBC_TYPE_NUMBERS[i] + "' then " + SPIConnection.JDBC_TYPE_NUMBERS[i];
        }
        sql = sql + " else 1111 end from pg_type where oid=t.typbasetype) else null end as base_type from pg_catalog.pg_type t, pg_catalog.pg_namespace n where t.typnamespace = n.oid and n.nspname != 'pg_catalog' and n.nspname != 'pg_toast'";
        String toAdd = "";
        if (types != null) {
            toAdd = toAdd + " and (false ";
            block5: for (int i = 0; i < types.length; ++i) {
                switch (types[i]) {
                    case 2002: {
                        toAdd = toAdd + " or t.typtype = 'c'";
                        continue block5;
                    }
                    case 2001: {
                        toAdd = toAdd + " or t.typtype = 'd'";
                    }
                }
            }
            toAdd = toAdd + " ) ";
        } else {
            toAdd = toAdd + " and t.typtype IN ('c','d') ";
        }
        if (typeNamePattern != null) {
            int firstQualifier = typeNamePattern.indexOf(46);
            int secondQualifier = typeNamePattern.lastIndexOf(46);
            if (firstQualifier != -1) {
                schemaPattern = firstQualifier != secondQualifier ? typeNamePattern.substring(firstQualifier + 1, secondQualifier) : typeNamePattern.substring(0, firstQualifier);
                typeNamePattern = typeNamePattern.substring(secondQualifier + 1);
            }
            toAdd = toAdd + " and t.typname like '" + SPIDatabaseMetaData.escapeQuotes(typeNamePattern) + "'";
        }
        if (schemaPattern != null) {
            toAdd = toAdd + " and n.nspname like '" + SPIDatabaseMetaData.escapeQuotes(schemaPattern) + "'";
        }
        sql = sql + toAdd;
        sql = sql + " order by data_type, type_schem, type_name";
        ResultSet rs = this.createMetaDataStatement().executeQuery(sql);
        return rs;
    }

    public Connection getConnection() throws SQLException {
        return this.m_connection;
    }

    public boolean rowChangesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean rowChangesAreVisible(int type) throws SQLException {
        return false;
    }

    private Statement createMetaDataStatement() throws SQLException {
        return this.m_connection.createStatement(1003, 1007);
    }

    public boolean supportsSavepoints() throws SQLException {
        return this.getDatabaseMajorVersion() >= 8;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new UnsupportedFeatureException("DatabaseMetaData.getSuperTypes");
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new UnsupportedFeatureException("DatabaseMetaData.getSuperTables");
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new UnsupportedFeatureException("getAttributes");
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return true;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.m_connection.getVersionNumber()[0];
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.m_connection.getVersionNumber()[1];
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        return 2;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    private ResultSet createSyntheticResultSet(ResultSetField[] f, ArrayList tuples) throws SQLException {
        return new SyntheticResultSet(f, tuples);
    }

    static {
        HashMap<String, String> ht = new HashMap<String, String>();
        s_tableTypeClauses.put("TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname NOT LIKE 'pg!_%' ESCAPE '!' AND n.nspname <> 'information_schema'");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname NOT LIKE 'pg!_%' ESCAPE '!'");
        ht = new HashMap();
        s_tableTypeClauses.put("VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'v' AND n.nspname <> 'pg_catalog' AND n.nspname <> 'information_schema'");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname NOT LIKE 'pg!_%' ESCAPE '!'");
        ht = new HashMap();
        s_tableTypeClauses.put("INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname NOT LIKE 'pg!_%' ESCAPE '!' AND n.nspname <> 'information_schema'");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname NOT LIKE 'pg!_%' ESCAPE '!'");
        ht = new HashMap();
        s_tableTypeClauses.put("SEQUENCE", ht);
        ht.put("SCHEMAS", "c.relkind = 'S'");
        ht.put("NOSCHEMAS", "c.relkind = 'S'");
        ht = new HashMap();
        s_tableTypeClauses.put("SYSTEM TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema')");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'pg!_%' ESCAPE '!' AND c.relname NOT LIKE 'pgLIKE 'pg!_toast!_%' ESCAPE '!'toast!_%' ESCAPE '!' AND c.relname NOT LIKE 'pg!_temp!_%' ESCAPE '!'");
        ht = new HashMap();
        s_tableTypeClauses.put("SYSTEM TOAST TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'pg_toast'");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'pg!_toast!_%' ESCAPE '!'");
        ht = new HashMap();
        s_tableTypeClauses.put("SYSTEM TOAST INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'pg_toast'");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname LIKE 'pg!_toast!_%' ESCAPE '!'");
        ht = new HashMap();
        s_tableTypeClauses.put("SYSTEM VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'v' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname LIKE 'pg!_%' ESCAPE '!'");
        ht = new HashMap();
        s_tableTypeClauses.put("SYSTEM INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname LIKE 'pg!_%' ESCAPE '!' AND c.relname NOT LIKE 'pg!_toast!_%' ESCAPE '!' AND c.relname NOT LIKE 'pg!_temp!_%' ESCAPE '!'");
        ht = new HashMap();
        s_tableTypeClauses.put("TEMPORARY TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname LIKE 'pg!_temp!_%' ESCAPE '!' ");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'pg!_temp!_%' ESCAPE '!' ");
        ht = new HashMap();
        s_tableTypeClauses.put("TEMPORARY INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname LIKE 'pg!_temp!_%' ESCAPE '!' ");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname LIKE 'pg!_temp!_%' ESCAPE '!' ");
        s_defaultTableTypes = new String[]{"TABLE", "VIEW", "INDEX", "SEQUENCE", "TEMPORARY TABLE"};
    }
}

