/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.postgresql.pljava.jdbc.SPIConnection;

public class SPIDriver
implements Driver {
    private static final String s_defaultURL = "jdbc:default:connection";
    private static final int s_defaultURLLen = "jdbc:default:connection".length();
    private static final Connection s_defaultConn = new SPIConnection();
    private static final DriverPropertyInfo[] s_noInfo = new DriverPropertyInfo[0];

    public Connection connect(String url, Properties info) throws SQLException {
        return this.acceptsURL(url) ? s_defaultConn : null;
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(s_defaultURL) && (url.length() == s_defaultURLLen || url.charAt(s_defaultURLLen) == ':');
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return s_noInfo;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static Connection getDefault() {
        return s_defaultConn;
    }

    static {
        try {
            DriverManager.registerDriver(new SPIDriver());
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

