/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.AbstractResultSetMetaData;

public class SPIResultSetMetaData
extends AbstractResultSetMetaData {
    private final TupleDesc m_tupleDesc;

    public SPIResultSetMetaData(TupleDesc tupleDesc) {
        this.m_tupleDesc = tupleDesc;
    }

    public final int getColumnCount() throws SQLException {
        return this.m_tupleDesc.size();
    }

    public final boolean isAutoIncrement(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    public final String getColumnLabel(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.m_tupleDesc.getColumnName(column).toUpperCase();
    }

    public final String getColumnClassName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.getOid(column).getJavaClass().getName();
    }

    protected final void checkColumnIndex(int column) throws SQLException {
        if (column < 1 || column > this.m_tupleDesc.size()) {
            throw new SQLException("Invalid column index: " + column);
        }
    }

    protected final Oid getOid(int column) throws SQLException {
        return this.m_tupleDesc.getOid(column);
    }

    protected final int getFieldLength(int column) throws SQLException {
        return 0;
    }
}

