/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import org.postgresql.pljava.internal.ExecutionPlan;
import org.postgresql.pljava.internal.Portal;
import org.postgresql.pljava.internal.SPI;
import org.postgresql.pljava.internal.SPIException;
import org.postgresql.pljava.jdbc.SPIConnection;
import org.postgresql.pljava.jdbc.SPIResultSet;
import org.postgresql.pljava.jdbc.StatementClosedException;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIStatement
implements Statement {
    private final SPIConnection m_connection;
    private String m_cursorName = null;
    private int m_fetchSize = 1000;
    private int m_maxRows = 0;
    private ResultSet m_resultSet = null;
    private int m_updateCount = 0;
    private ArrayList m_batch = null;
    private boolean m_closed = false;

    public SPIStatement(SPIConnection conn) {
        this.m_connection = conn;
    }

    public void addBatch(String statement) throws SQLException {
        this.internalAddBatch(statement);
    }

    public void cancel() throws SQLException {
    }

    public void clearBatch() throws SQLException {
        this.m_batch = null;
    }

    public void clearWarnings() throws SQLException {
    }

    private void clear() throws SQLException {
        if (this.m_resultSet != null) {
            this.m_resultSet.close();
        }
        this.m_updateCount = -1;
        this.m_cursorName = null;
        this.m_batch = null;
    }

    public void close() throws SQLException {
        this.clear();
        this.m_closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String statement) throws SQLException {
        this.clear();
        ExecutionPlan plan = ExecutionPlan.prepare(this.m_connection.nativeSQL(statement), null);
        int result = SPI.getResult();
        if (plan == null) {
            throw new SPIException(result);
        }
        try {
            boolean bl = this.executePlan(plan, null);
            return bl;
        }
        finally {
            try {
                plan.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executePlan(ExecutionPlan plan, Object[] paramValues) throws SQLException {
        this.m_updateCount = -1;
        this.m_resultSet = null;
        boolean isResultSet = plan.isCursorPlan();
        if (isResultSet) {
            Portal portal = plan.cursorOpen(this.m_cursorName, paramValues);
            this.m_resultSet = new SPIResultSet(this, portal, this.m_maxRows);
        } else {
            try {
                plan.execute(paramValues, this.m_maxRows);
                this.m_updateCount = SPI.getProcessed();
            }
            finally {
                SPI.freeTupTable();
            }
        }
        return isResultSet;
    }

    public boolean execute(String statement, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedFeatureException("Statement.execute(String,int)");
    }

    public boolean execute(String statement, int[] columnIndexes) throws SQLException {
        throw new UnsupportedFeatureException("Statement.execute(String,int[])");
    }

    public boolean execute(String statement, String[] columnNames) throws SQLException {
        throw new UnsupportedFeatureException("Statement.execute(String,String[])");
    }

    public int[] executeBatch() throws SQLException {
        int numBatches = this.m_batch == null ? 0 : this.m_batch.size();
        int[] result = new int[numBatches];
        for (int idx = 0; idx < numBatches; ++idx) {
            result[idx] = this.executeBatchEntry(this.m_batch.get(idx));
        }
        return result;
    }

    public ResultSet executeQuery(String statement) throws SQLException {
        this.execute(statement);
        return this.getResultSet();
    }

    public int executeUpdate(String statement) throws SQLException {
        this.execute(statement);
        return this.getUpdateCount();
    }

    public int executeUpdate(String statement, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    public int executeUpdate(String statement, int[] columnIndexes) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    public int executeUpdate(String statement, String[] columnNames) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    public Connection getConnection() throws SQLException {
        if (this.m_connection == null) {
            throw new StatementClosedException();
        }
        return this.m_connection;
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        return this.m_fetchSize;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("JDK 1.4 functionality not yet implemented");
    }

    public int getMaxFieldSize() throws SQLException {
        return Integer.MAX_VALUE;
    }

    public int getMaxRows() throws SQLException {
        return this.m_maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        return false;
    }

    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.m_resultSet;
    }

    public int getResultSetConcurrency() {
        return 1007;
    }

    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("JDK 1.4 functionality not yet implemented");
    }

    public int getResultSetType() {
        return 1003;
    }

    public int getUpdateCount() throws SQLException {
        return this.m_updateCount;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.m_closed) {
            throw new SQLException("getWarnings: Statement is closed");
        }
        return null;
    }

    public void setCursorName(String cursorName) throws SQLException {
        this.m_cursorName = cursorName;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedFeatureException("Statement.setEscapeProcessing");
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new UnsupportedFeatureException("Non forward fetch direction");
        }
    }

    public void setFetchSize(int size) throws SQLException {
        this.m_fetchSize = size;
    }

    public void setMaxFieldSize(int size) throws SQLException {
        throw new UnsupportedFeatureException("Statement.setMaxFieldSize");
    }

    public void setMaxRows(int rows) throws SQLException {
        this.m_maxRows = rows;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        throw new UnsupportedFeatureException("Statement.setQueryTimeout");
    }

    protected void internalAddBatch(Object batch) throws SQLException {
        if (this.m_batch == null) {
            this.m_batch = new ArrayList();
        }
        this.m_batch.add(batch);
    }

    protected int executeBatchEntry(Object batchEntry) throws SQLException {
        int ret = -2;
        if (this.execute(this.m_connection.nativeSQL((String)batchEntry))) {
            this.getResultSet().close();
        } else if (this.m_updateCount >= 0) {
            ret = this.m_updateCount;
        }
        return ret;
    }

    void resultSetClosed(ResultSet rs) {
        if (rs == this.m_resultSet) {
            this.m_resultSet = null;
        }
    }
}

