/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Time;
import java.sql.Timestamp;
import org.postgresql.pljava.internal.Backend;

public class SQLInputFromChunk
implements SQLInput {
    private static final byte[] s_byteBuffer = new byte[8];
    private final int m_chunkSize;
    private int m_position;
    private long m_handle;

    public SQLInputFromChunk(long handle, int chunkSize) {
        this.m_handle = handle;
        this.m_chunkSize = chunkSize;
        this.m_position = 0;
    }

    public Array readArray() throws SQLException {
        throw new UnsupportedOperationException("readArray");
    }

    public InputStream readAsciiStream() throws SQLException {
        throw new UnsupportedOperationException("readAsciiStream");
    }

    public BigDecimal readBigDecimal() throws SQLException {
        return new BigDecimal(this.readString());
    }

    public InputStream readBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.readBytes());
    }

    public Blob readBlob() throws SQLException {
        throw new UnsupportedOperationException("readBlob");
    }

    public boolean readBoolean() throws SQLException {
        int c = this.read();
        if (c < 0) {
            throw new SQLException("Unexpected EOF on data input");
        }
        return c != 0;
    }

    public byte readByte() throws SQLException {
        int c = this.read();
        if (c < 0) {
            throw new SQLException("Unexpected EOF on data input");
        }
        return (byte)c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            if (this.m_handle == 0L) {
                throw new SQLException("Stream is closed");
            }
            if (this.m_chunkSize - this.m_position < 2) {
                throw new SQLException("Unexpected EOF on data input");
            }
            SQLInputFromChunk._readBytes(this.m_handle, this.m_position, s_byteBuffer, 2);
            this.m_position += 2;
            int len = (s_byteBuffer[0] & 0xFF) << 8 | s_byteBuffer[1] & 0xFF;
            byte[] buffer = new byte[len];
            if (len > 0) {
                SQLInputFromChunk._readBytes(this.m_handle, this.m_position, buffer, len);
                this.m_position += len;
            }
            return buffer;
        }
    }

    public Reader readCharacterStream() throws SQLException {
        return new StringReader(this.readString());
    }

    public Clob readClob() throws SQLException {
        throw new UnsupportedOperationException("readClob");
    }

    public Date readDate() throws SQLException {
        return new Date(this.readLong());
    }

    public double readDouble() throws SQLException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws SQLException {
        return Float.intBitsToFloat(this.readInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            if (this.m_chunkSize - this.m_position < 4) {
                throw new SQLException("Unexpected EOF on data input");
            }
            SQLInputFromChunk._readBytes(this.m_handle, this.m_position, s_byteBuffer, 4);
            this.m_position += 4;
            return (s_byteBuffer[0] & 0xFF) << 24 | (s_byteBuffer[1] & 0xFF) << 16 | (s_byteBuffer[2] & 0xFF) << 8 | s_byteBuffer[3] & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            if (this.m_chunkSize - this.m_position < 8) {
                throw new SQLException("Unexpected EOF on data input");
            }
            SQLInputFromChunk._readBytes(this.m_handle, this.m_position, s_byteBuffer, 8);
            this.m_position += 8;
            return (long)(s_byteBuffer[0] & 0xFF) << 56 | (long)(s_byteBuffer[1] & 0xFF) << 48 | (long)(s_byteBuffer[2] & 0xFF) << 40 | (long)(s_byteBuffer[3] & 0xFF) << 32 | (long)(s_byteBuffer[4] & 0xFF) << 24 | (long)((s_byteBuffer[5] & 0xFF) << 16) | (long)((s_byteBuffer[6] & 0xFF) << 8) | (long)(s_byteBuffer[7] & 0xFF);
        }
    }

    public Object readObject() throws SQLException {
        throw new UnsupportedOperationException("readObject");
    }

    public Ref readRef() throws SQLException {
        throw new UnsupportedOperationException("readRef");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short readShort() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            if (this.m_chunkSize - this.m_position < 2) {
                throw new SQLException("Unexpected EOF on data input");
            }
            SQLInputFromChunk._readBytes(this.m_handle, this.m_position, s_byteBuffer, 2);
            this.m_position += 2;
            return (short)((s_byteBuffer[0] & 0xFF) << 8 | s_byteBuffer[1] & 0xFF);
        }
    }

    public String readString() throws SQLException {
        try {
            return new String(this.readBytes(), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("UTF8 encoding not supported by JVM");
        }
    }

    public Time readTime() throws SQLException {
        return new Time(this.readLong());
    }

    public Timestamp readTimestamp() throws SQLException {
        return new Timestamp(this.readLong());
    }

    public URL readURL() throws SQLException {
        try {
            return new URL(this.readString());
        }
        catch (MalformedURLException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public boolean wasNull() throws SQLException {
        return false;
    }

    void close() {
        this.m_handle = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read() throws SQLException {
        if (this.m_position < this.m_chunkSize) {
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                if (this.m_handle == 0L) {
                    throw new SQLException("Stream is closed");
                }
                return SQLInputFromChunk._readByte(this.m_handle, this.m_position++);
            }
        }
        return -1;
    }

    private static native int _readByte(long var0, int var2);

    private static native void _readBytes(long var0, int var2, byte[] var3, int var4);
}

