/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import org.postgresql.pljava.internal.Backend;

public class SQLOutputToChunk
implements SQLOutput {
    private static final byte[] s_byteBuffer = new byte[8];
    private long m_handle;

    public SQLOutputToChunk(long handle) {
        this.m_handle = handle;
    }

    public void writeArray(Array value) throws SQLException {
        throw new UnsupportedOperationException("writeArray");
    }

    public void writeAsciiStream(InputStream value) throws SQLException {
        throw new UnsupportedOperationException("writeAsciiStream");
    }

    public void writeBigDecimal(BigDecimal value) throws SQLException {
        this.writeString(value.toString());
    }

    public void writeBinaryStream(InputStream value) throws SQLException {
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bld = new ByteArrayOutputStream();
        try {
            int count;
            while ((count = value.read(buf)) > 0) {
                bld.write(buf, 0, count);
            }
            this.writeBytes(bld.toByteArray());
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void writeBlob(Blob value) throws SQLException {
        throw new UnsupportedOperationException("writeBlob");
    }

    public void writeBoolean(boolean value) throws SQLException {
        this.write(value ? 1 : 0);
    }

    public void writeByte(byte value) throws SQLException {
        this.write(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBytes(byte[] buffer) throws SQLException {
        int len = buffer.length;
        if (len > 0) {
            if (len > 65535) {
                throw new SQLException("Byte buffer exceeds maximum size of 65535 bytes");
            }
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                if (this.m_handle == 0L) {
                    throw new SQLException("Stream is closed");
                }
                SQLOutputToChunk.s_byteBuffer[0] = (byte)(len >> 8 & 0xFF);
                SQLOutputToChunk.s_byteBuffer[1] = (byte)(len & 0xFF);
                SQLOutputToChunk._writeBytes(this.m_handle, s_byteBuffer, 2);
                SQLOutputToChunk._writeBytes(this.m_handle, buffer, len);
            }
        }
    }

    public void writeCharacterStream(Reader value) throws SQLException {
        char[] buf = new char[1024];
        StringWriter bld = new StringWriter();
        try {
            int count;
            while ((count = value.read(buf)) > 0) {
                bld.write(buf, 0, count);
            }
            this.writeString(bld.toString());
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void writeClob(Clob value) throws SQLException {
        throw new UnsupportedOperationException("writeClob");
    }

    public void writeDate(Date value) throws SQLException {
        this.writeLong(value.getTime());
    }

    public void writeDouble(double value) throws SQLException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeFloat(float value) throws SQLException {
        this.writeInt(Float.floatToIntBits(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInt(int value) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            SQLOutputToChunk.s_byteBuffer[0] = (byte)(value >>> 24);
            SQLOutputToChunk.s_byteBuffer[1] = (byte)(value >>> 16);
            SQLOutputToChunk.s_byteBuffer[2] = (byte)(value >>> 8);
            SQLOutputToChunk.s_byteBuffer[3] = (byte)(value >>> 0);
            SQLOutputToChunk._writeBytes(this.m_handle, s_byteBuffer, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLong(long value) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            SQLOutputToChunk.s_byteBuffer[0] = (byte)(value >>> 56);
            SQLOutputToChunk.s_byteBuffer[1] = (byte)(value >>> 48);
            SQLOutputToChunk.s_byteBuffer[2] = (byte)(value >>> 40);
            SQLOutputToChunk.s_byteBuffer[3] = (byte)(value >>> 32);
            SQLOutputToChunk.s_byteBuffer[4] = (byte)(value >>> 24);
            SQLOutputToChunk.s_byteBuffer[5] = (byte)(value >>> 16);
            SQLOutputToChunk.s_byteBuffer[6] = (byte)(value >>> 8);
            SQLOutputToChunk.s_byteBuffer[7] = (byte)(value >>> 0);
            SQLOutputToChunk._writeBytes(this.m_handle, s_byteBuffer, 8);
        }
    }

    public void writeObject(SQLData value) throws SQLException {
        throw new UnsupportedOperationException("writeObject");
    }

    public void writeRef(Ref value) throws SQLException {
        throw new UnsupportedOperationException("writeRef");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeShort(short value) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            SQLOutputToChunk.s_byteBuffer[0] = (byte)(value >>> 8);
            SQLOutputToChunk.s_byteBuffer[1] = (byte)(value >>> 0);
            SQLOutputToChunk._writeBytes(this.m_handle, s_byteBuffer, 2);
        }
    }

    public void writeString(String value) throws SQLException {
        try {
            this.writeBytes(value.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("UTF8 encoding not supported by JVM");
        }
    }

    public void writeStruct(Struct value) throws SQLException {
        throw new UnsupportedOperationException("writeStruct");
    }

    public void writeTime(Time value) throws SQLException {
        this.writeLong(value.getTime());
    }

    public void writeTimestamp(Timestamp value) throws SQLException {
        this.writeLong(value.getTime());
    }

    public void writeURL(URL value) throws SQLException {
        this.writeString(value.toString());
    }

    void close() {
        this.m_handle = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(int b) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            if (this.m_handle == 0L) {
                throw new SQLException("Stream is closed");
            }
            SQLOutputToChunk._writeByte(this.m_handle, b);
        }
    }

    private static native void _writeByte(long var0, int var2);

    private static native void _writeBytes(long var0, byte[] var2, int var3);
}

