/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.SingleRowResultSet;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SingleRowReader
extends SingleRowResultSet {
    private final TupleDesc m_tupleDesc;
    private final long m_pointer;

    public SingleRowReader(long pointer, TupleDesc tupleDesc) throws SQLException {
        this.m_pointer = pointer;
        this.m_tupleDesc = tupleDesc;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            this._free(this.m_pointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectValue(int columnIndex) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return SingleRowReader._getObject(this.m_pointer, this.m_tupleDesc.getNativePointer(), columnIndex);
        }
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public void cancelRowUpdates() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public void deleteRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public void insertRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public void moveToInsertRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public void updateRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    private static SQLException readOnlyException() {
        return new UnsupportedFeatureException("ResultSet is read-only");
    }

    protected final TupleDesc getTupleDesc() {
        return this.m_tupleDesc;
    }

    protected native void _free(long var1);

    private static native Object _getObject(long var0, long var2, int var4) throws SQLException;
}

