/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.ObjectResultSet;
import org.postgresql.pljava.jdbc.SPIResultSetMetaData;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public abstract class SingleRowResultSet
extends ObjectResultSet {
    public int getConcurrency() throws SQLException {
        return 1008;
    }

    public int findColumn(String columnName) throws SQLException {
        return this.getTupleDesc().getColumnIndex(columnName);
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        return 1;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new SPIResultSetMetaData(this.getTupleDesc());
    }

    public int getRow() throws SQLException {
        return 1;
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public void afterLast() throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public void beforeFirst() throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public boolean first() throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public boolean isAfterLast() throws SQLException {
        return false;
    }

    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    public boolean isFirst() throws SQLException {
        return true;
    }

    public boolean isLast() throws SQLException {
        return true;
    }

    public boolean last() throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public boolean next() throws SQLException {
        return false;
    }

    public boolean previous() throws SQLException {
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new UnsupportedFeatureException("Non forward fetch direction");
        }
    }

    public void setFetchSize(int fetchSize) throws SQLException {
        if (fetchSize != 1) {
            throw new IllegalArgumentException("Illegal fetch size for single row set");
        }
    }

    public boolean absolute(int row) throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public boolean relative(int rows) throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public void deleteRow() throws SQLException {
        throw new UnsupportedFeatureException("Deletes not supported on single row set");
    }

    public void insertRow() throws SQLException {
        throw new UnsupportedFeatureException("Inserts not supported on single row set");
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedFeatureException("Inserts not supported on single row set");
    }

    public void updateRow() throws SQLException {
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.updateObject(columnIndex, x);
    }

    protected abstract TupleDesc getTupleDesc() throws SQLException;
}

