/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.BlobValue;
import org.postgresql.pljava.jdbc.SPIConnection;
import org.postgresql.pljava.jdbc.SingleRowResultSet;

public class SingleRowWriter
extends SingleRowResultSet {
    private final TupleDesc m_tupleDesc;
    private final Object[] m_values;
    private Tuple m_tuple;

    public SingleRowWriter(TupleDesc tupleDesc) throws SQLException {
        this.m_tupleDesc = tupleDesc;
        this.m_values = new Object[tupleDesc.size()];
    }

    protected Object getObjectValue(int columnIndex) throws SQLException {
        if (columnIndex < 1) {
            throw new SQLException("System columns cannot be obtained from this type of ResultSet");
        }
        return this.m_values[columnIndex - 1];
    }

    public boolean rowUpdated() throws SQLException {
        int top = this.m_values.length;
        while (--top >= 0) {
            if (this.m_values[top] == null) continue;
            return true;
        }
        return false;
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        Class c;
        if (columnIndex < 1) {
            throw new SQLException("System columns cannot be updated");
        }
        if (x == null) {
            this.m_values[columnIndex - 1] = x;
        }
        if (!((c = this.m_tupleDesc.getColumnClass(columnIndex)).isInstance(x) || c == [B.class && x instanceof BlobValue)) {
            x = Number.class.isAssignableFrom(c) ? SPIConnection.basicNumericCoersion(c, x) : (Time.class.isAssignableFrom(c) || Date.class.isAssignableFrom(c) || Timestamp.class.isAssignableFrom(c) ? SPIConnection.basicCalendricalCoersion(c, x, Calendar.getInstance()) : SPIConnection.basicCoersion(c, x));
        }
        this.m_values[columnIndex - 1] = x;
    }

    public void cancelRowUpdates() throws SQLException {
        Arrays.fill(this.m_values, null);
    }

    public void close() throws SQLException {
        Arrays.fill(this.m_values, null);
        this.m_tuple = null;
    }

    public void copyRowFrom(ResultSet rs) throws SQLException {
        int top = this.m_values.length;
        for (int idx = 0; idx < top; ++idx) {
            this.m_values[idx] = rs.getObject(idx + 1);
        }
    }

    public long getTupleAndClear() throws SQLException {
        this.m_tuple = this.getTupleDesc().formTuple(this.m_values);
        Arrays.fill(this.m_values, null);
        return this.m_tuple.getNativePointer();
    }

    protected final TupleDesc getTupleDesc() {
        return this.m_tupleDesc;
    }
}

