/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.AbstractResultSetMetaData;
import org.postgresql.pljava.jdbc.ResultSetField;

public class SyntheticResultSetMetaData
extends AbstractResultSetMetaData {
    private final ResultSetField[] m_fields;

    public SyntheticResultSetMetaData(ResultSetField[] fields) {
        this.m_fields = fields;
    }

    public final int getColumnCount() throws SQLException {
        return this.m_fields.length;
    }

    public final boolean isAutoIncrement(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    public final String getColumnLabel(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.m_fields[column - 1].getColumnLabel();
    }

    public final String getColumnClassName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.m_fields[column - 1].getJavaClass().getName();
    }

    protected final void checkColumnIndex(int column) throws SQLException {
        if (column < 1 || column > this.m_fields.length) {
            throw new SQLException("Invalid column index: " + column);
        }
    }

    protected final Oid getOid(int column) throws SQLException {
        return this.m_fields[column - 1].getOID();
    }

    protected final int getFieldLength(int column) throws SQLException {
        return this.m_fields[column - 1].getLength();
    }
}

