/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.SingleRowResultSet;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class TriggerResultSet
extends SingleRowResultSet {
    private ArrayList m_tupleChanges;
    private final TupleDesc m_tupleDesc;
    private final Tuple m_tuple;
    private final boolean m_readOnly;

    public TriggerResultSet(TupleDesc tupleDesc, Tuple tuple, boolean readOnly) throws SQLException {
        this.m_tupleDesc = tupleDesc;
        this.m_tuple = tuple;
        this.m_readOnly = readOnly;
    }

    public void cancelRowUpdates() throws SQLException {
        this.m_tupleChanges = null;
    }

    public void close() throws SQLException {
        this.m_tupleChanges = null;
    }

    public int getConcurrency() throws SQLException {
        return this.m_readOnly ? 1007 : 1008;
    }

    public boolean rowUpdated() throws SQLException {
        return this.m_tupleChanges != null;
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        if (this.m_readOnly) {
            throw new UnsupportedFeatureException("ResultSet is read-only");
        }
        if (this.m_tupleChanges == null) {
            this.m_tupleChanges = new ArrayList();
        }
        this.m_tupleChanges.add(new Integer(columnIndex));
        this.m_tupleChanges.add(x);
    }

    public Object[] getChangeIndexesAndValues() {
        ArrayList changes = this.m_tupleChanges;
        if (changes == null) {
            return null;
        }
        int top = changes.size();
        if (changes.size() == 0) {
            return null;
        }
        int[] indexes = new int[top /= 2];
        Object[] values = new Object[top];
        int vIdx = 0;
        for (int idx = 0; idx < top; ++idx) {
            indexes[idx] = (Integer)changes.get(vIdx++);
            values[idx] = changes.get(vIdx++);
        }
        return new Object[]{this.m_tuple, indexes, values};
    }

    protected Object getObjectValue(int columnIndex) throws SQLException {
        ArrayList changes = this.m_tupleChanges;
        if (changes != null) {
            int top = changes.size();
            for (int idx = 0; idx < top; idx += 2) {
                if (columnIndex != (Integer)changes.get(idx)) continue;
                return changes.get(idx + 1);
            }
        }
        return this.m_tuple.getObject(this.getTupleDesc(), columnIndex);
    }

    protected final TupleDesc getTupleDesc() {
        return this.m_tupleDesc;
    }
}

