/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.management;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import org.postgresql.pljava.internal.AclId;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.SQLUtils;
import org.postgresql.pljava.management.SQLDeploymentDescriptor;
import org.postgresql.pljava.sqlj.Loader;

public class Commands {
    private static final Logger s_logger = Logger.getLogger(Commands.class.getName());

    public static void addClassImages(int jarId, InputStream urlStream) throws SQLException {
        PreparedStatement stmt = null;
        PreparedStatement descIdStmt = null;
        ResultSet rs = null;
        try {
            JarEntry je;
            int deployImageId = -1;
            byte[] buf = new byte[1024];
            ByteArrayOutputStream img = new ByteArrayOutputStream();
            stmt = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.jar_entry(entryName, jarId, entryImage) VALUES(?, ?, ?)");
            JarInputStream jis = new JarInputStream(urlStream);
            Manifest manifest = jis.getManifest();
            if (manifest != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                manifest.write(out);
                PreparedStatement us = SQLUtils.getDefaultConnection().prepareStatement("UPDATE sqlj.jar_repository SET jarManifest = ? WHERE jarId = ?");
                try {
                    us.setString(1, new String(out.toByteArray(), "UTF8"));
                    us.setInt(2, jarId);
                    if (us.executeUpdate() != 1) {
                        throw new SQLException("Jar repository update did not update 1 row");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new SQLException("JVM does not support UTF8!!");
                }
                finally {
                    SQLUtils.close(us);
                }
            }
            while ((je = jis.getNextJarEntry()) != null) {
                int nBytes;
                if (je.isDirectory()) continue;
                String entryName = je.getName();
                Attributes attrs = je.getAttributes();
                boolean isDepDescr = false;
                if (attrs != null && (isDepDescr = "true".equalsIgnoreCase(attrs.getValue("SQLJDeploymentDescriptor"))) && deployImageId >= 0) {
                    throw new SQLException("Only one SQLJDeploymentDescriptor allowed");
                }
                img.reset();
                while ((nBytes = jis.read(buf)) > 0) {
                    img.write(buf, 0, nBytes);
                }
                jis.closeEntry();
                stmt.setString(1, entryName);
                stmt.setInt(2, jarId);
                stmt.setBytes(3, img.toByteArray());
                if (stmt.executeUpdate() != 1) {
                    throw new SQLException("Jar entry insert did not insert 1 row");
                }
                if (!isDepDescr) continue;
                descIdStmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT entryId FROM sqlj.jar_entry WHERE jarId = ? AND entryName = ?");
                descIdStmt.setInt(1, jarId);
                descIdStmt.setString(2, entryName);
                rs = descIdStmt.executeQuery();
                if (!rs.next()) {
                    throw new SQLException("Failed to refecth row in sqlj.jar_entry");
                }
                deployImageId = rs.getInt(1);
            }
            if (deployImageId >= 0) {
                stmt.close();
                stmt = SQLUtils.getDefaultConnection().prepareStatement("UPDATE sqlj.jar_repository SET deploymentDesc = ? WHERE jarId = ?");
                stmt.setInt(1, deployImageId);
                stmt.setInt(2, jarId);
                if (stmt.executeUpdate() != 1) {
                    throw new SQLException("Jar repository update did not insert 1 row");
                }
            }
        }
        catch (IOException e) {
            try {
                throw new SQLException("I/O exception reading jar file: " + e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.close(rs);
                SQLUtils.close(descIdStmt);
                SQLUtils.close(stmt);
                throw throwable;
            }
        }
        SQLUtils.close(rs);
        SQLUtils.close(descIdStmt);
        SQLUtils.close(stmt);
    }

    public static void addTypeMapping(String sqlTypeName, String javaClassName) throws SQLException {
        PreparedStatement stmt = null;
        try {
            ClassLoader loader = Loader.getCurrentLoader();
            Class<?> cls = loader.loadClass(javaClassName);
            if (!SQLData.class.isAssignableFrom(cls)) {
                throw new SQLException("Class " + javaClassName + " does not implement java.sql.SQLData");
            }
            sqlTypeName = Commands.getFullSqlName(sqlTypeName);
            stmt = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.typemap_entry(javaName, sqlName) VALUES(?,?)");
            stmt.setString(1, javaClassName);
            stmt.setString(2, sqlTypeName);
            stmt.executeUpdate();
        }
        catch (ClassNotFoundException e) {
            try {
                throw new SQLException("No such class: " + javaClassName);
            }
            catch (Throwable throwable) {
                SQLUtils.close(stmt);
                throw throwable;
            }
        }
        SQLUtils.close(stmt);
        Loader.clearSchemaLoaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropTypeMapping(String sqlTypeName) throws SQLException {
        PreparedStatement stmt = null;
        try {
            sqlTypeName = Commands.getFullSqlName(sqlTypeName);
            stmt = SQLUtils.getDefaultConnection().prepareStatement("DELETE FROM sqlj.typemap_entry WHERE sqlName = ?");
            stmt.setString(1, sqlTypeName);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            SQLUtils.close(stmt);
            throw throwable;
        }
        SQLUtils.close(stmt);
        Loader.clearSchemaLoaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassPath(String schemaName) throws SQLException {
        String string;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            schemaName = schemaName == null || schemaName.length() == 0 ? "public" : schemaName.toLowerCase();
            stmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT r.jarName FROM sqlj.jar_repository r INNER JOIN sqlj.classpath_entry c ON r.jarId = c.jarId WHERE c.schemaName = ? ORDER BY c.ordinal");
            stmt.setString(1, schemaName);
            rs = stmt.executeQuery();
            StringBuffer buf = null;
            while (rs.next()) {
                if (buf == null) {
                    buf = new StringBuffer();
                } else {
                    buf.append(':');
                }
                buf.append(rs.getString(1));
            }
            string = buf == null ? null : buf.toString();
        }
        catch (Throwable throwable) {
            SQLUtils.close(rs);
            SQLUtils.close(stmt);
            throw throwable;
        }
        SQLUtils.close(rs);
        SQLUtils.close(stmt);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentSchema() throws SQLException {
        Statement stmt = SQLUtils.getDefaultConnection().createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery("SELECT current_schema()");
            if (!rs.next()) {
                throw new SQLException("Unable to obtain current schema");
            }
            String string = rs.getString(1);
            return string;
        }
        finally {
            SQLUtils.close(rs);
            SQLUtils.close(stmt);
        }
    }

    public static void installJar(byte[] image, String jarName, boolean deploy) throws SQLException {
        Commands.installJar("streamed byte image", jarName, deploy, image);
    }

    public static void installJar(String urlString, String jarName, boolean deploy) throws SQLException {
        Commands.installJar(urlString, jarName, deploy, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeJar(String jarName, boolean undeploy) throws SQLException {
        Commands.assertJarName(jarName);
        AclId[] ownerRet = new AclId[1];
        int jarId = Commands.getJarId(jarName, ownerRet);
        if (jarId < 0) {
            throw new SQLException("No Jar named '" + jarName + "' is known to the system");
        }
        AclId user = AclId.getSessionUser();
        if (!user.isSuperuser() && !user.equals(ownerRet[0])) {
            throw new SecurityException("Only super user or owner can remove a jar");
        }
        if (undeploy) {
            Commands.deployRemove(jarId, jarName);
        }
        PreparedStatement stmt = SQLUtils.getDefaultConnection().prepareStatement("DELETE FROM sqlj.jar_repository WHERE jarId = ?");
        try {
            stmt.setInt(1, jarId);
            if (stmt.executeUpdate() != 1) {
                throw new SQLException("Jar repository update did not update 1 row");
            }
        }
        finally {
            SQLUtils.close(stmt);
        }
        Loader.clearSchemaLoaders();
    }

    public static void replaceJar(byte[] jarImage, String jarName, boolean redeploy) throws SQLException {
        Commands.replaceJar("streamed byte image", jarName, redeploy, jarImage);
    }

    public static void replaceJar(String urlString, String jarName, boolean redeploy) throws SQLException {
        Commands.replaceJar(urlString, jarName, redeploy, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClassPath(String schemaName, String path) throws SQLException {
        int jarId;
        PreparedStatement stmt;
        if (schemaName == null || schemaName.length() == 0) {
            schemaName = "public";
        }
        if ("public".equals(schemaName)) {
            if (!AclId.getSessionUser().isSuperuser()) {
                throw new SQLException("Permission denied. Only a super user can set the classpath of the public schema");
            }
        } else {
            Oid schemaId = Commands.getSchemaId(schemaName = schemaName.toLowerCase());
            if (schemaId == null) {
                throw new SQLException("No such schema: " + schemaName);
            }
            if (!AclId.getSessionUser().hasSchemaCreatePermission(schemaId)) {
                throw new SQLException("Permission denied. User must have create permission on the target schema in order to set the classpath");
            }
        }
        ArrayList<Integer> entries = null;
        if (path != null && path.length() > 0) {
            entries = new ArrayList<Integer>();
            stmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT jarId FROM sqlj.jar_repository WHERE jarName = ?");
            try {
                int colon;
                do {
                    String jarName;
                    if ((colon = path.indexOf(58)) >= 0) {
                        jarName = path.substring(0, colon);
                        path = path.substring(colon + 1);
                    } else {
                        jarName = path;
                    }
                    jarId = Commands.getJarId(stmt, jarName, null);
                    if (jarId < 0) {
                        throw new SQLException("No such jar: " + jarName);
                    }
                    entries.add(new Integer(jarId));
                } while (colon >= 0);
            }
            finally {
                SQLUtils.close(stmt);
            }
        }
        stmt = SQLUtils.getDefaultConnection().prepareStatement("DELETE FROM sqlj.classpath_entry WHERE schemaName = ?");
        try {
            stmt.setString(1, schemaName);
            stmt.executeUpdate();
        }
        finally {
            SQLUtils.close(stmt);
        }
        if (entries != null) {
            stmt = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.classpath_entry(schemaName, ordinal, jarId) VALUES(?, ?, ?)");
            try {
                int top = entries.size();
                for (int idx = 0; idx < top; ++idx) {
                    jarId = (Integer)entries.get(idx);
                    stmt.setString(1, schemaName);
                    stmt.setInt(2, idx + 1);
                    stmt.setInt(3, jarId);
                    stmt.executeUpdate();
                }
            }
            finally {
                SQLUtils.close(stmt);
            }
        }
        Loader.clearSchemaLoaders();
    }

    private static boolean assertInPath(String jarName, String[] originalSchemaAndPath) throws SQLException {
        String currentSchema = Commands.getCurrentSchema();
        String currentClasspath = Commands.getClassPath(currentSchema);
        originalSchemaAndPath[0] = currentSchema;
        originalSchemaAndPath[1] = currentClasspath;
        if (currentClasspath == null) {
            Commands.setClassPath(currentSchema, jarName);
            return true;
        }
        String[] elems = currentClasspath.split(":");
        int idx = elems.length;
        boolean found = false;
        while (--idx >= 0) {
            if (!elems[idx].equals(jarName)) continue;
            found = true;
            break;
        }
        if (found) {
            return false;
        }
        Commands.setClassPath(currentSchema, jarName + ':' + currentClasspath);
        return true;
    }

    private static void assertJarName(String jarName) throws SQLException {
        int len;
        if (jarName != null && (len = jarName.length()) > 0 && Character.isJavaIdentifierStart(jarName.charAt(0))) {
            int idx;
            for (idx = 1; idx < len && Character.isJavaIdentifierPart(jarName.charAt(idx)); ++idx) {
            }
            if (idx == len) {
                return;
            }
        }
        throw new SQLException("The jar name '" + jarName + "' is not a valid name");
    }

    private static void deployInstall(int jarId, String jarName) throws SQLException {
        SQLDeploymentDescriptor depDesc = Commands.getDeploymentDescriptor(jarId);
        if (depDesc == null) {
            return;
        }
        String[] originalSchemaAndPath = new String[2];
        boolean classpathChanged = Commands.assertInPath(jarName, originalSchemaAndPath);
        depDesc.install(SQLUtils.getDefaultConnection());
        if (classpathChanged) {
            Commands.setClassPath(originalSchemaAndPath[0], originalSchemaAndPath[1]);
        }
    }

    private static void deployRemove(int jarId, String jarName) throws SQLException {
        SQLDeploymentDescriptor depDesc = Commands.getDeploymentDescriptor(jarId);
        if (depDesc == null) {
            return;
        }
        String[] originalSchemaAndPath = new String[2];
        boolean classpathChanged = Commands.assertInPath(jarName, originalSchemaAndPath);
        depDesc.remove(SQLUtils.getDefaultConnection());
        if (classpathChanged) {
            Commands.setClassPath(originalSchemaAndPath[0], originalSchemaAndPath[1]);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SQLDeploymentDescriptor getDeploymentDescriptor(int jarId) throws SQLException {
        SQLDeploymentDescriptor sQLDeploymentDescriptor;
        byte[] bytes;
        PreparedStatement stmt;
        ResultSet rs;
        block8: {
            block7: {
                rs = null;
                stmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT e.entryImage FROM sqlj.jar_repository r INNER JOIN sqlj.jar_entry e   ON r.deploymentDesc = e.entryId WHERE r.jarId = ?");
                stmt.setInt(1, jarId);
                rs = stmt.executeQuery();
                if (rs.next()) break block7;
                SQLDeploymentDescriptor sQLDeploymentDescriptor2 = null;
                SQLUtils.close(rs);
                SQLUtils.close(stmt);
                return sQLDeploymentDescriptor2;
            }
            bytes = rs.getBytes(1);
            if (bytes.length != 0) break block8;
            SQLDeploymentDescriptor sQLDeploymentDescriptor3 = null;
            SQLUtils.close(rs);
            SQLUtils.close(stmt);
            return sQLDeploymentDescriptor3;
        }
        try {
            sQLDeploymentDescriptor = new SQLDeploymentDescriptor(new String(bytes, "UTF8"), "postgresql");
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new SQLException("JVM does not support UTF8!!");
                catch (ParseException e2) {
                    throw new SQLException(e2.getMessage() + " at " + e2.getErrorOffset());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.close(rs);
                SQLUtils.close(stmt);
                throw throwable;
            }
        }
        SQLUtils.close(rs);
        SQLUtils.close(stmt);
        return sQLDeploymentDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFullSqlName(String sqlTypeName) throws SQLException {
        String string;
        Oid typeId = Oid.forTypeName(sqlTypeName);
        s_logger.info("Type id = " + typeId.toString());
        ResultSet rs = null;
        PreparedStatement stmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT n.nspname, t.typname FROM pg_type t, pg_namespace n WHERE t.oid = ? AND n.oid = t.typnamespace");
        try {
            stmt.setObject(1, typeId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new SQLException("Unable to obtain type info for " + typeId);
            }
            string = rs.getString(1) + '.' + rs.getString(2);
        }
        catch (Throwable throwable) {
            SQLUtils.close(rs);
            SQLUtils.close(stmt);
            throw throwable;
        }
        SQLUtils.close(rs);
        SQLUtils.close(stmt);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getJarId(PreparedStatement stmt, String jarName, AclId[] ownerRet) throws SQLException {
        stmt.setString(1, jarName);
        ResultSet rs = stmt.executeQuery();
        try {
            if (!rs.next()) {
                int n = -1;
                return n;
            }
            int id = rs.getInt(1);
            if (ownerRet != null) {
                String ownerName = rs.getString(2);
                ownerRet[0] = AclId.fromName(ownerName);
            }
            int n = id;
            return n;
        }
        finally {
            SQLUtils.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getJarId(String jarName, AclId[] ownerRet) throws SQLException {
        PreparedStatement stmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT jarId, jarOwner FROM sqlj.jar_repository WHERE jarName = ?");
        try {
            int n = Commands.getJarId(stmt, jarName, ownerRet);
            return n;
        }
        finally {
            SQLUtils.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Oid getSchemaId(String schemaName) throws SQLException {
        PreparedStatement stmt;
        ResultSet rs;
        block3: {
            Oid oid;
            rs = null;
            stmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT oid FROM pg_namespace WHERE nspname = ?");
            try {
                stmt.setString(1, schemaName);
                rs = stmt.executeQuery();
                if (rs.next()) break block3;
                oid = null;
            }
            catch (Throwable throwable) {
                SQLUtils.close(rs);
                SQLUtils.close(stmt);
                throw throwable;
            }
            SQLUtils.close(rs);
            SQLUtils.close(stmt);
            return oid;
        }
        Oid oid = (Oid)rs.getObject(1);
        SQLUtils.close(rs);
        SQLUtils.close(stmt);
        return oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installJar(String urlString, String jarName, boolean deploy, byte[] image) throws SQLException {
        Commands.assertJarName(jarName);
        if (Commands.getJarId(jarName, null) >= 0) {
            throw new SQLException("A jar named '" + jarName + "' already exists");
        }
        PreparedStatement stmt = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.jar_repository(jarName, jarOrigin, jarOwner) VALUES(?, ?, ?)");
        try {
            stmt.setString(1, jarName);
            stmt.setString(2, urlString);
            stmt.setString(3, AclId.getSessionUser().getName());
            if (stmt.executeUpdate() != 1) {
                throw new SQLException("Jar repository insert did not insert 1 row");
            }
        }
        finally {
            SQLUtils.close(stmt);
        }
        AclId[] ownerRet = new AclId[1];
        int jarId = Commands.getJarId(jarName, ownerRet);
        if (jarId < 0) {
            throw new SQLException("Unable to obtain id of '" + jarName + "'");
        }
        if (image == null) {
            Backend.addClassImages(jarId, urlString);
        } else {
            ByteArrayInputStream imageStream = new ByteArrayInputStream(image);
            Commands.addClassImages(jarId, imageStream);
        }
        Loader.clearSchemaLoaders();
        if (deploy) {
            Commands.deployInstall(jarId, jarName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceJar(String urlString, String jarName, boolean redeploy, byte[] image) throws SQLException {
        AclId[] ownerRet = new AclId[1];
        int jarId = Commands.getJarId(jarName, ownerRet);
        if (jarId < 0) {
            throw new SQLException("No Jar named '" + jarName + "' is known to the system");
        }
        AclId user = AclId.getSessionUser();
        if (!user.isSuperuser() && !user.equals(ownerRet[0])) {
            throw new SecurityException("Only super user or owner can replace a jar");
        }
        if (redeploy) {
            Commands.deployRemove(jarId, jarName);
        }
        PreparedStatement stmt = SQLUtils.getDefaultConnection().prepareStatement("UPDATE sqlj.jar_repository SET jarOrigin = ?, jarOwner = ?, jarManifest = NULL, deploymentDesc = NULL WHERE jarId = ?");
        try {
            stmt.setString(1, urlString);
            stmt.setString(2, user.getName());
            stmt.setInt(3, jarId);
            if (stmt.executeUpdate() != 1) {
                throw new SQLException("Jar repository update did not update 1 row");
            }
        }
        finally {
            SQLUtils.close(stmt);
        }
        stmt = SQLUtils.getDefaultConnection().prepareStatement("DELETE FROM sqlj.jar_entry WHERE jarId = ?");
        try {
            stmt.setInt(1, jarId);
            stmt.executeUpdate();
        }
        finally {
            SQLUtils.close(stmt);
        }
        if (image == null) {
            Backend.addClassImages(jarId, urlString);
        } else {
            ByteArrayInputStream imageStream = new ByteArrayInputStream(image);
            Commands.addClassImages(jarId, imageStream);
        }
        Loader.clearSchemaLoaders();
        if (redeploy) {
            Commands.deployInstall(jarId, jarName);
        }
    }
}

