#!/bin/bash
# Copyright (c) 2012-2014, EnterpriseDB Corporation.  All rights reserved

# Where are we going to write to?
LOGFILE="edb-audit-report.log"

os=`uname | awk '{print $1}'`

echo
echo "**************************************************************************"
echo "----------------------------- EDB Audit ----------------------------------"
echo "**************************************************************************"
echo "EnterpriseDB audit log file generated and placed in current directory." 
echo "Please include this file when reporting an issue via the ticketing system"
echo "(see www.enterprisedb.com) or by sending email to support@enterprisedb.com"

proceesor_type(){

	if [ "$os" = "Linux" ]
	then
        	# Get processor Type
        	procType=`awk '/model name/ {for(i=1;i<=NF;i=i+1) printf("%s ",$i);}' /proc/cpuinfo`
        	procType=`echo ${procType#model name : }`

	elif [ "$os" = "SunOS" ]
	then
        	# Get the Processor type
        	procType=`/usr/sbin/psrinfo -v 0 | grep operates | awk '{printf("%s %s %s",$2,$6,$7)}' | awk -F',' '{printf ("%s",$1)}'`

	elif [ "$os" = "Darwin" ]
	then
        	# Get Processor type
        	t=`uname -m`
        	if [ "$t" = "i386" ]
        	then
                	procType=`sysctl -n machdep.cpu.brand_string | awk '{printf("%s %s %s",$1,$2,$3)}'`
                	procSpd=`sysctl -n machdep.cpu.brand_string | awk -F'@' '{printf("%s",$2)}'`
                	procType="$procType$procSpd"
        	else

                	procType=`sysctl -n hw.machine`
                	procSpd=`sysctl -n hw.cpufrequency_max`
                	procSpd=`expr $procSpd / 1000000`
                	# Convert Proc spd from Hz to MHz
               	 	procType=$procType" "$procSpd" MHz"
        	fi
	fi
        echo PROCESSOR_TYPE=$procType >$LOGFILE
}

number_of_cores(){

	
        if [ "$os" = "Linux" ]
        then
		# Get number of processor cores
                nProc=`cat /proc/cpuinfo | grep ^processor | wc -l`
	elif [ "$os" = "SunOS" ]
        then
		# Get the number of processor cores
                nProc=`/usr/bin/kstat -m cpu_info | grep core_id | uniq | wc -l | tr -d ' '`
	elif [ "$os" = "Darwin" ]
        then
		# Get number of processor cores
                nProc=`sysctl -n hw.ncpu`
	fi
	echo NUMBER_OF_CORES=$nProc >>$LOGFILE
}

processor_arch(){

	if [ -e /etc/debian_version ]
	then
		procArch=`uname -m`
	else
		procArch=`uname -p`
	fi
	echo PROCESSOR_ARCH=$procArch >>$LOGFILE
}

memory_info(){

	if [ "$os" = "Linux" ]
        then
		# Get ram
                totalMem=`cat /proc/meminfo | grep MemTotal | awk -F':' '{print $2}'| sed 's/^[ \t]*//' |sed 's/k[bB]//'`
        elif [ "$os" = "SunOS" ]
        then
		# Get ram in MB
		tMem=`/usr/sbin/prtconf | head -3 | grep 'Memory size'`
		totalMem=`echo $tMem | awk '{print $3}'`
        elif [ "$os" = "Darwin" ]
        then
		# Get ram
                totalMem=`sysctl -n hw.memsize`
        fi

	INSTALLED_BC=`which bc`
	# Make sure that ram is a numeric
	totalMemRound=`expr $totalMem`

	if [ "$os" = "SunOS" ]
        then
		if [ "x"$INSTALLED_BC = "x" ]; then
                	totalMeminKB=`expr $totalMemRound * 1024`
        	else
                	totalMeminKB=`echo "scale=2;$totalMemRound*1024"|bc`
        	fi	
	else
		totalMeminKB=$totalMemRound
	fi
	echo TOTAL_MEMORY_IN_KB=$totalMeminKB KB >>$LOGFILE	
}

os_info(){

	if [ "$os" = "Linux" ]
        then
		os_name=$os
		# Get distribution name
                if [ -e /etc/debian_version ]
                then
                        osFile=/etc/issue
                else
                        osFile=`ls -al --time-style=full-iso /etc/*-release |grep -v lsb |grep -v ^l |awk '{print $9}' | head -n 1`
                fi
                osVersion=`cat $osFile | sed q | awk 'BEGIN { FS="@"
                                                        } 
                                                    { 
                                                        newlineIndex = index ($1,"\\\\n")
                                                        if (newlineIndex == 0)
                                                          print $1
                                                        else
                                                          print (substr($1,1,newlineIndex-1))
                                                        }'`
        elif [ "$os" = "SunOS" ]
        then
		os_name="Solaris"
		osVersion=`uname -r`
        elif [ "$os" = "Darwin" ]
        then
		os_name="Macintosh"
		osVersion=`sysctl -n kern.osrelease`
        fi

	echo OS=$os_name $osVersion >>$LOGFILE	
}

proceesor_type
number_of_cores
processor_arch
memory_info
os_info
