/*-------------------------------------------------------------------------
 *
 * dblinkam.h
 *	  EnterpriseDB remote access method definitions.
 *
 *
 * Portions Copyright (c) 2004-2013, EnterpriseDB Corporation.
 *
 *-------------------------------------------------------------------------
 */
#ifndef DBLINKAM_H
#define DBLINKAM_H

/* 
 * Member of this enumeration represent a dbms to which we can connect.
 *
 * Note: these are duplicated in pg_dump.c. Change that as well if you
 * touch these!
 */
typedef enum DbmsType
{
	DBMS_UNKNOWN = 0,
	DBMS_ORACLE,
	DBMS_EDB,
} DbmsType;


/*
 * Attribute type info for each of the attributes for DMLs. This info is used
 * for generating column names, parameter markers, and binding parameter values
 * for the remote DMLs. When a column value is specified as DEFAULT (UPDATE tab
 * set col1 = DEFAULT), the value is REMOTE_ATTRIBUTE_DEFAULT. If a column is
 * to be ommitted in the remote DML (such as when user omitted the column value,
 * or if the column is a dropped column) the value should be
 * REMOTE_ATTRIBUTE_OMITTED, otherwise it is REMOTE_ATTRIBUTE_NORMAL.
 */
typedef enum
{
	REMOTE_ATTRIBUTE_NORMAL = 0,
	REMOTE_ATTRIBUTE_DEFAULT,
	REMOTE_ATTRIBUTE_OMITTED
} RemoteAttributeType;


/* ----------------
 *		function prototypes for dblink access method
 * ----------------
 */
extern Oid LookupDatabaseLink(const char *linkname, bool publiclnkonly);

extern void dblink_tablename(Oid foreigntableid, char **schema, char **table);
extern bool is_temp_foreign_table(Oid foreigntableid);
extern void get_dblink_options(Oid serverid, char **username, char **password,
							   char **connstr);

#endif   /* DBLINKAM_H */
