/*-------------------------------------------------------------------------
 *
 * utils.h
 *	  prototypes for dblink utils.c.
 *
 * Portions Copyright (c) 2004-2013, EnterpriseDB Corporation.
 *-------------------------------------------------------------------------
 */
#ifndef UTILS_H
#define UTILS_H

#include "nodes/primnodes.h"
#include "nodes/relation.h"

extern char		  *build_remote_select(DbmsType dbmsType, RelOptInfo *rel,
                            char *wherestr, char *att_needed[],
                            int natts);
extern char		   get_db_param_char(DbmsType dbtype);
extern char		  *get_ctid_fs(Oid foreigntableid);
extern char		  *obfuscate_password(char *linkuser, char *password);
extern char		  *deobfuscate_password(char *linkuser, char *password);
extern void		   slot_to_cstrings(TupleTableSlot *slot,
									RemoteAttributeType *attr_types,
									char **outval);
extern const char *stripErrorPrefix(const char *errmsg);

#endif
