/*-------------------------------------------------------------------------
 *
 * edb_partdef.h
 *	  Defines the partition definitions table (edb_partdef)
 *
 * Copyright (c) 2011-2013, EnterpriseDB Corporation. All Rights Reserved.
 *
 *-------------------------------------------------------------------------
 */
#ifndef EDB_PARTDEF_H
#define EDB_PARTDEF_H

#include "catalog/genbki.h"

#define EDBPartDefRelationId	3124

CATALOG(edb_partdef,3124)
{
	Oid			 pdefrel;		   /* OID of root table */
    char         pdeftype;         /* Partition type (range,list,hash,...) */
	char		 pdefsubtype;	   /* Subpartition type */
	int2vector   pdefcols;		   /* Partition columns (attribute numbers) */
	int2vector	 pdefsubcols;	   /* Subpartition columns (attribute numbers) */
	pg_node_tree pdefkeyexpr;	   /* Partition key expression - currently unused */
	pg_node_tree pdefinsertexpr;   /* Insert expression - currently unused */
} FormData_edb_partdef;

typedef FormData_edb_partdef *Form_edb_partdef;

/* ----------------
 *      compiler constants for edb_partdef
 * ----------------
 */
#define Natts_edb_partdef               		7
#define Anum_edb_partdef_pdefrel      	 		1
#define Anum_edb_partdef_pdeftype      			2
#define Anum_edb_partdef_pdefsubtype			3
#define Anum_edb_partdef_pdefcols				4
#define Anum_edb_partdef_pdefsubcols			5
#define Anum_edb_partdef_pdefkeyexpr		    6
#define Anum_edb_partdef_pdefinsertexpr			7

#endif /* EDB_PARTDEF_H */
