/*-------------------------------------------------------------------------
 *
 * edb_partition.h
 *	  Defines the partition specification table (edb_partition)
 *
 * Copyright (c) 2011-2013, EnterpriseDB Corporation. All Rights Reserved.
 *
 *-------------------------------------------------------------------------
 */
#ifndef EDB_PARTITION_H
#define EDB_PARTITION_H

#include "catalog/genbki.h"

/* ----------------
 *	edb_partition definition.  cpp turns this into
 *	typedef struct FormData_edb_partitions
 * ----------------
 */
#define EDBPartitionRelationId 3125

CATALOG(edb_partition,3125) 
{
	NameData	partname;		/* Name of partition */
	int32		partpos;		/* Position of partition within root */
    Oid         partpdefid;     /* OID of partdef tuple */
	Oid			partrelid;		/* OID of the backing table (in pg_class) */
    Oid         partparent;     /* OID of parent edb_partition (or InvalidOid) */
	Oid			partcons;		/* OID of CHECK constraint for this partition */
	Oid			parttablespace;	/* Table space for this partition */
	bool	    partistemplate;	/* Is this is a subpartition template? */

#ifdef CATALOG_VARLEN			/* variable-length fields start here */
	pg_node_tree partvals;		/* Partition values */
#endif
} FormData_edb_partition;

typedef FormData_edb_partition *Form_edb_partition;

/* ----------------
 *      compiler constants for edb_partitions
 * ----------------
 */
#define Natts_edb_partition               9

#define Anum_edb_partition_partname       1
#define Anum_edb_partition_partpos		  2
#define Anum_edb_partition_partpdefid     3
#define Anum_edb_partition_partrelid	  4
#define Anum_edb_partition_partparent     5
#define Anum_edb_partition_partcons		  6
#define Anum_edb_partition_parttablespace 7
#define Anum_edb_partition_partistemplate 8
#define Anum_edb_partition_partvals       9

#endif   /* EDB_PARTITIONS_H */
