/*
 * Copyright (c) 2011-2013, EnterpriseDB Corporation. All Rights Reserved.
 */
#ifndef EDB_POLICY_H
#define EDB_POLICY_H

#include "catalog/genbki.h"

#define EDBPolicyRelationId  2999

CATALOG(edb_policy,2999) 
{
	NameData   policyname;		  /* Policy name */
	Oid		   policygroup;		  /* Group to which policy belongs or InvalidOid */
	Oid		   policyobject;	  /* Object (table, view, synonym) that policy applies to */
	char	   policykind;		  /* See POLICYKIND_xxx constants below */
	Oid		   policyproc;		  /* OID of predicate function */
	bool	   policyinsert;	  /* Apply policy to INSERT? */
	bool	   policyselect;	  /* Apply policy to SELECT? */
	bool	   policydelete;	  /* Apply policy to DELETE? */
	bool	   policyupdate;	  /* Apply policy to UPDATE? */
	bool	   policyindex;		  /* Apply policy to INDEX? */
	bool	   policyenabled;	  /* Enabled? */
	bool	   policyupdatecheck; /* Ensure that UPDATE produces a row readable by caller? */
	bool	   policystatic;	  /* Currently unused */
	int32	   policytype;		  /* Currently unused */
	int32	   policyopts;		  /* Bitmask of policy options - should this be a text[] instead; like pg_class.reloptions? */
	int2vector policyseccols;	  /* Security-relevant attribute numbers */
} FormData_edb_policy;

typedef FormData_edb_policy *Form_edb_policy;

#define Natts_edb_policy                    16

#define Anum_edb_policy_policyname		  1
#define Anum_edb_policy_policygroup		  2
#define Anum_edb_policy_policyobject	  3
#define Anum_edb_policy_policykind		  4
#define Anum_edb_policy_policyproc		  5
#define Anum_edb_policy_policyinsert	  6
#define Anum_edb_policy_policyselect	  7
#define Anum_edb_policy_policydelete	  8
#define Anum_edb_policy_policyupdate	  9
#define Anum_edb_policy_policyindex		  10
#define Anum_edb_policy_policyenabled	  11
#define Anum_edb_policy_policyupdatecheck 12
#define Anum_edb_policy_policystatic	  13
#define Anum_edb_policy_policytype		  14
#define Anum_edb_policy_policyopts		  15
#define Anum_edb_policy_policyseccols	  16

/*
 * Values for policykind
 */
#define POLICYKIND_TABLE				'r'
#define POLICYKIND_VIEW					'v'
#define POLICYKIND_SYNONYM				'='

/*
 * Values for policytype
 */
#define POLICYTYPE_UNDEFINED				0
#define POLICYTYPE_STATIC					1
#define POLICYTYPE_SHARED_STATIC			2
#define POLICYTYPE_CONTEXT_SENSITIVE		3
#define POLICYTYPE_SHARED_CONTEXT_SENSITIVE	4
#define POLICYTYPE_DYNAMIC					5

/*
 * Values for policyopts
 */
#define POLICYOPT_HIDE_ROWS					0 	/* Hide rows if any member of policyseccols is referenced */
#define POLICYOPT_ALL_ROWS					1	/* Return all rows, but NULL-out any security-relevant columns */

#endif   /* EDB_POLICY_H */
