/*
 * Copyright (c) 2004-2013, EnterpriseDB Corporation. All Rights Reserved.
 */
#ifndef EDB_VARIABLE_H
#define EDB_VARIABLE_H

#include "catalog/genbki.h"
#include "nodes/parsenodes.h"

#define VariableRelationId  2893

CATALOG(edb_variable,2893)
{
	NameData	varname;
	Oid			varpackage;
	Oid 		vartype;
	int32		vartypmod;
	char		varaccess;
	bool		varisconst;
	text		varsrc;
	int32		varseq;
	int32		varerrcode;
	text		varexceptionname;
} FormData_edb_variable;

typedef FormData_edb_variable *Form_edb_variable;

#define Natts_edb_variable					10
#define Anum_edb_variable_varname			1
#define Anum_edb_variable_varpackage		2
#define Anum_edb_variable_vartype			3
#define Anum_edb_variable_vartypmod			4
#define Anum_edb_variable_varaccess			5
#define Anum_edb_variable_varisconst        6
#define Anum_edb_variable_varsrc			7
#define Anum_edb_variable_varseq			8
#define Anum_edb_variable_varerrcode        9
#define Anum_edb_variable_varexceptionname  10

extern Oid VariableCreate(char *varname,
						  Oid   varpackage,
						  Oid   vartype,
						  int32	vartypmod,
						  bool  varaccess,
						  bool	varisconst,
						  char *varsrc,
						  int   varnum,
						  List *cursorparams,
						  Node *cursorquery,
						  bool  replace);

/*
 * This is used as vartype for EXCEPTION variables.
 */
#define EDB_VARIABLE_EXCEPTION_TYPE 	0

/*
 * Symbolic values for edb_variable.varaccess column.
 */
#define VARACCESS_PUBLIC				'+'
#define VARACCESS_PRIVATE				'-'
#define VARACCESS_PUBLIC_PARAMCUR		'p'
#define VARACCESS_PRIVATE_PARAMCUR		'r'
#define VARACCESS_PUBLIC_NOPARAMCUR		'P'
#define VARACCESS_PRIVATE_NOPARAMCUR	'R'

#define VARACCESS_IS_PUBLIC(a)  (((a) == VARACCESS_PUBLIC)  || ((a) == VARACCESS_PUBLIC_PARAMCUR)  || ((a) == VARACCESS_PUBLIC_NOPARAMCUR))
#define VARACCESS_IS_PRIVATE(a) (((a) == VARACCESS_PRIVATE) || ((a) == VARACCESS_PRIVATE_PARAMCUR) || ((a) == VARACCESS_PRIVATE_NOPARAMCUR))

#endif   /* EDB_VARIABLE_H */
