/*-------------------------------------------------------------------------
 *
 * pg_namespace.h
 *	  definition of the system "namespace" relation (pg_namespace)
 *	  along with the relation's initial contents.
 *
 *
 * Portions Copyright (c) 1996-2013, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 * Portions Copyright (c) 2004-2013, EnterpriseDB Corporation.
 *
 * src/include/catalog/pg_namespace.h
 *
 * NOTES
 *	  the genbki.pl script reads this file and generates .bki
 *	  information from the DATA() statements.
 *
 *-------------------------------------------------------------------------
 */
#ifndef PG_NAMESPACE_H
#define PG_NAMESPACE_H

#include "catalog/genbki.h"

/* ----------------------------------------------------------------
 *		pg_namespace definition.
 *
 *		cpp turns this into typedef struct FormData_pg_namespace
 *
 *	nspname				name of the namespace
 *	nspowner			owner (creator) of the namespace
 *	nspacl				access privilege list
 * ----------------------------------------------------------------
 */
#define NamespaceRelationId  2615

CATALOG(pg_namespace,2615)
{
	NameData	nspname;
	Oid			nspowner;
	Oid			nspparent;
	Oid			nspobjecttype;
	Oid			nspforeignserver;
	bool		nspsecdef;
	text	    nspremoteschema;
	text		nspheadsrc;
	text		nspbodysrc;

#ifdef CATALOG_VARLEN			/* variable-length fields start here */
	aclitem		nspacl[1];
#endif
} FormData_pg_namespace;

/* ----------------
 *		Form_pg_namespace corresponds to a pointer to a tuple with
 *		the format of pg_namespace relation.
 * ----------------
 */
typedef FormData_pg_namespace *Form_pg_namespace;

/* ----------------
 *		compiler constants for pg_namespace
 * ----------------
 */

#define Natts_pg_namespace				10
#define Anum_pg_namespace_nspname		1
#define Anum_pg_namespace_nspowner		2
#define Anum_pg_namespace_nspparent		3
#define Anum_pg_namespace_nspobjecttype 4
#define Anum_pg_namespace_nspforeignserver 5
#define Anum_pg_namespace_nspsecdef		6
#define Anum_pg_namespace_nspremoteschema 7
#define Anum_pg_namespace_nspheadsrc	8
#define Anum_pg_namespace_nspbodysrc	9
#define Anum_pg_namespace_nspacl		10



/* ----------------
 * initial contents of pg_namespace
 * ---------------
 */

DATA(insert OID = 11 ( "pg_catalog" PGUID 0 0 0 f _null_ _null_ _null_ _null_));
DESCR("System catalog schema");
#define PG_CATALOG_NAMESPACE 11
DATA(insert OID = 9 ( "sys" PGUID 0 0 0 f _null_ _null_ _null_ _null_));
DESCR("sys schema");
#define SYS_NAMESPACE 9
DATA(insert OID = 8 ( "dbo" PGUID 0 0 0 f _null_ _null_ _null_ _null_));
DESCR("dbo schema");
#define DBO_NAMESPACE 8
/*
 * SUPPORT_TSQL
 * Removing the edb_tsql entry from here since
 * we need to disable the TSQL functionality
DATA(insert OID = 7 ( "edb_tsql" PGUID 0 0 f _null_ _null_ _null_ _null_));
DESCR("tsql schema");
#define TSQL_NAMESPACE 7
*/
DATA(insert OID = 99 ( "pg_toast" PGUID 0 0 0 f _null_ _null_ _null_ _null_));
DESCR("Reserved schema for TOAST tables");
#define PG_TOAST_NAMESPACE 99
DATA(insert OID = 2200 ( "public" PGUID 0 0 0 f _null_ _null_ _null_ _null_));
DESCR("Standard public schema");
#define PG_PUBLIC_NAMESPACE 2200


/*
 * prototypes for functions in pg_namespace.c
 */
extern Oid	NamespaceCreate(const char *nspName, Oid ownerId, bool isTemp,
							Oid dblinkId, const char *linkSearchPath);

extern Oid NamespaceHeadCreate(char *nspname, Oid parentnsp,
							   bool replace, char *headsrc, bool secdef,
							   Oid objtypid);
extern void UpdateNamespaceAttribute(Oid nspid, int attnum, char *attval);

#endif   /* PG_NAMESPACE_H */
