/*-------------------------------------------------------------------------
 *
 * dblinkcmds.h
 *	  prototypes for dblinkcmds.c.
 *
 * Copyright (c) 2004-2013, EnterpriseDB Corporation. All Rights Reserved.
 *
 *-------------------------------------------------------------------------
 */

#ifndef DBLINKCMDS_H
#define DBLINKCMDS_H

#include "foreign/foreign.h"
#include "nodes/parsenodes.h"

extern void CreateDatabaseLink(CreateDBLinkStmt *stmt);
extern Oid AlterDBLinkOwner(List *name, Oid newOwnerId);
extern void RemoveDatabaseLink(char *linkname, bool ispublic,
							   DropBehavior behavior, bool missing_ok);
extern void SyncLinkMetaData(Oid dblinkOid, Oid relnamespace,
				 char *remoteSearchPath);

extern Oid	GetPrivateDBLinkOid(const char *linkname, Oid ownerId);

extern bool have_createdblink_privilege(void);
extern bool have_createpublicdblink_privilege(void);
extern bool have_droppublicdblink_privilege(void);
extern Oid	is_private_dblink_name(const char *srvname);
extern char *private_dblink_name(const char *linkname, Oid ownerId);
extern char *new_private_dblink_name(const char *linkname, Oid ownerId);

#endif   /* DBLINKCMDS_H */
