/*-------------------------------------------------------------------------
 *
 * packagecmds.h
 *	  prototypes for packagecmds.c.
 *
 * Copyright (c) 2004-2013, EnterpriseDB Corporation. All Rights Reserved.
 *
 * src/include/commands/packagecmds.h
 *
 *-------------------------------------------------------------------------
 */

#ifndef PACKAGECMDS_H
#define PACKAGECMDS_H

#include "nodes/parsenodes.h"
#include "utils/array.h"
#include "utils/syscache.h"
#include "utils/catcache.h"

extern void CreatePackageHeader(CreatePackageHeadStmt *parsetree,
								Oid typrelid, char *typattrs);
extern void CreatePackageBody(CreatePackageBodyStmt *parsetree, bool isimplicit,
							  Oid typrelid, char *typattrs);

extern void RemovePackageBodies(DropStmt *drop);
extern void RemovePrivateElements(Oid packageId, bool remove_body);
extern void RemovePackageById(Oid packageOid);
extern bool GetDummyParseState(void);
extern void SetDummyParseState(bool state);

extern Oid AlterPackageOwner(List *names, Oid newOwnerId);

#endif   /* SCHEMACMDS_H */
