/*-------------------------------------------------------------------------
 *
 * schemacmds.h
 *	  prototypes for schemacmds.c.
 *
 *
 * Portions Copyright (c) 1996-2013, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * src/include/commands/schemacmds.h
 *
 *-------------------------------------------------------------------------
 */

#ifndef SCHEMACMDS_H
#define SCHEMACMDS_H

#include "nodes/parsenodes.h"
#include "utils/rel.h"

extern Oid CreateSchemaCommand(CreateSchemaStmt *parsetree,
					const char *queryString);

extern void RemoveSchemaById(Oid schemaOid);

extern Oid	RenameSchema(const char *oldname, const char *newname);
extern Oid	AlterSchemaOwner(const char *name, Oid newOwnerId);
extern void AlterSchemaOwner_oid(Oid schemaOid, Oid newOwnerId);
extern void AlterSchemaOwner_internal(HeapTuple tup, Relation rel, Oid newOwnerId);
extern void AlterSchemaLinkCommand(AlterSchemaLinkStmt *n);

#endif   /* SCHEMACMDS_H */
