/*-------------------------------------------------------------------------
 *
 * nodeModifyTable.h
 *
 *
 * Portions Copyright (c) 1996-2013, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * src/include/executor/nodeModifyTable.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef NODEMODIFYTABLE_H
#define NODEMODIFYTABLE_H

#include "nodes/execnodes.h"

extern ModifyTableState *ExecInitModifyTable(ModifyTable *node, EState *estate, int eflags);
extern TupleTableSlot *ExecModifyTable(ModifyTableState *node);
extern void ExecEndModifyTable(ModifyTableState *node);
extern void ExecReScanModifyTable(ModifyTableState *node);
extern void ExecCheckPolicy(ResultRelInfo *resultRelInfo, TupleTableSlot *slot, EState *estate);
extern void ExecInsertBatch(EState *estate, CommandId mycid,
				int hi_options, ResultRelInfo *resultRelInfo,
				TupleTableSlot *tmpslot, BulkInsertState bistate,
				int nBufferedTuples, HeapTuple *bufferedTuples);

/* EDB: Export mostly-internal APIs for occasional use. */
extern TupleTableSlot *ExecInsert(ModifyTableState *node,
		   TupleTableSlot *slot,
		   TupleTableSlot *planSlot,
		   EState *estate,
		   int hi_options,
		   bool canSetTag);
extern TupleTableSlot *ExecDelete(ModifyTableState *node,
		   ItemPointer tupleid,
		   HeapTupleHeader oldtuple,
		   TupleTableSlot *planSlot,
		   EPQState *epqstate,
		   EState *estate,
		   bool canSetTag,
		   TupleTableSlot *remoteslot,
		   HeapTuple prior_trigtuple);

#endif   /* NODEMODIFYTABLE_H */
