/*-------------------------------------------------------------------------
 *
 * hints.h
 *	  
 *
 * Portions Copyright (c) 2007-2013, EnterpriseDB Corporation
 * Portions Copyright (c) 1996-2005, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * src/include/optimizer/hints.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef HINTS_H
#define HINTS_H

#include "nodes/parsenodes.h"
#include "nodes/relation.h"
#include "lib/stringinfo.h"
#include "utils/guc.h"
#include "utils/rel.h"

extern bool 	 enable_hints;
extern bool 	 trace_hints;
extern int		 optimizer_mode;	/* enum HintType */

extern bool hints_allow_path(Path *path);
extern bool hints_is_ordered(List *hints, bool emit_info_trace);
extern bool hints_is_append(List *hints);
extern List *remove_append_hint(List *hints);
extern const char *assign_optimizer_mode(const char *newval, bool doit,
											GucSource source);

extern char    *get_alias_name(Index relid, List *rtable);
extern void		add_optim_hints_to_rel(Query *parse, RelOptInfo *rel);
extern void		hints_adjust_tuple_fraction(List *hints, double *tuple_fraction);
extern void		shorten_first_arg(HintElem *h);
extern void		push_hints_into_subselect(List **hints, RangeSubselect *r);
extern void		push_hints_into_view(Query *parsetree, Query *rule_action, 
										char *alias);

/* In hintparse.c */
extern List	   *parse_hints(char *source);
extern void		deparse_hintelem(HintElem *h, StringInfo buf);
extern char	   *get_hint_name(HintElem *h);

/* Get a string value out of a Const; use it if you are sure that it contains string data */
#define Const2String(x) DatumGetCString( ((Const*)(x))->constvalue)	

#endif /* HINTS_H */
