/*-------------------------------------------------------------------------
 *
 * parse_clause.h
 *	  handle clauses in parser
 *
 *
 * Portions Copyright (c) 1996-2013, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 * Portions Copyright (c) 2004-2013, EnterpriseDB Corporation.
 *
 * src/include/parser/parse_clause.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef PARSE_CLAUSE_H
#define PARSE_CLAUSE_H

#include "parser/parse_node.h"

#define ORDER_CLAUSE 	   0
#define GROUP_CLAUSE 	   1
#define DISTINCT_ON_CLAUSE 2
#define CONNECTBY_CLAUSE   3

extern void transformFromClause(ParseState *pstate, List *frmList);
extern int setTargetTable(ParseState *pstate, RangeVar *relation,
			   bool inh, bool alsoSource, AclMode requiredPerms);
extern bool interpretInhOption(InhOption inhOpt);
extern bool interpretOidsOption(List *defList, bool allowOids);
extern bool interpretOidsOption(List *defList, char relkind);
extern bool interpretROWIDOption (List *defList);
extern HierClause *transformHierClause(ParseState *pstate,
								HierClause *hierClause,
								List **targetlist);
extern Node *transformWhereClause(ParseState *pstate, Node *clause,
					 ParseExprKind exprKind, const char *constructName);
extern Node *transformLimitClause(ParseState *pstate, Node *clause,
					 ParseExprKind exprKind, const char *constructName);
extern List *transformGroupClause(ParseState *pstate, List *grouplist,
					 List **targetlist, List *sortClause,
					 ParseExprKind exprKind, bool useSQL99);
extern List *transformSortClause(ParseState *pstate, List *orderlist,
					List **targetlist, ParseExprKind exprKind,
					bool resolveUnknown, bool useSQL99);
extern List *transformSortSiblingsClause(ParseState *pstate, List *orderlist,
								  List **targetlist, bool resolveUnknown);

extern List *transformWindowDefinitions(ParseState *pstate,
						   List *windowdefs,
						   List **targetlist);

extern List *transformDistinctClause(ParseState *pstate,
						List **targetlist, List *sortClause, bool is_agg);
extern List *transformDistinctOnClause(ParseState *pstate, List *distinctlist,
						  List **targetlist, List *sortClause);

extern Index assignSortGroupRef(TargetEntry *tle, List *tlist);
extern bool targetIsInSortList(TargetEntry *tle, Oid sortop, List *sortList);
extern JoinExpr *buildRedwoodJoin(ParseState *pstate, Node *leftTable,
				 Node *rightTable, JoinType joinType, Node *quals);

#endif   /* PARSE_CLAUSE_H */
