/*-------------------------------------------------------------------------
 *
 * parse_func.h
 *
 *
 *
 * Portions Copyright (c) 1996-2013, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 * Portions Copyright (c) 2004-2013, EnterpriseDB Corporation.
 *
 * src/include/parser/parse_func.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef PARSER_FUNC_H
#define PARSER_FUNC_H

#include "catalog/namespace.h"
#include "parser/parse_node.h"


/*
 *	This structure is used to explore the inheritance hierarchy above
 *	nodes in the type tree in order to disambiguate among polymorphic
 *	functions.
 */
typedef struct _InhPaths
{
	int			nsupers;		/* number of superclasses */
	Oid			self;			/* this class */
	Oid		   *supervec;		/* vector of superclasses */
}	InhPaths;

/* Result codes for func_get_detail */
typedef enum
{
	FUNCDETAIL_NOTFOUND,		/* no matching function */
	FUNCDETAIL_MULTIPLE,		/* too many matching functions */
	FUNCDETAIL_NORMAL,			/* found a matching regular function */
	FUNCDETAIL_AGGREGATE,		/* found a matching aggregate function */
	FUNCDETAIL_WINDOWFUNC,		/* found a matching window function */
	FUNCDETAIL_COERCION			/* it's a type coercion request */
} FuncDetailCode;

extern Node *ParseFuncOrColumn(ParseState *pstate,
				  List *funcname, List *fargs,
				  List *agg_order, bool agg_star, bool agg_distinct,
				  bool func_variadic,
				  WindowDef *over, bool is_column, int location);

extern FuncDetailCode func_get_detail(List *funcname,
				List *fargs, List *fargnames,
				int nargs, Oid *argtypes,
				bool expand_variadic, bool expand_defaults,
				Oid *funcid, Oid *pkgid, Oid *rettype,
				bool *retset, int *nvargs, Oid **true_typeids,
				List **argdefaults, int *actual_args,
				char protype, bool redwood_out_style);

extern int func_match_argtypes(int nargs,
					Oid *input_typeids,
					FuncCandidateList raw_candidates,
					FuncCandidateList *candidates);

extern FuncCandidateList func_select_candidate(int nargs,
					  Oid *input_typeids,
					  FuncCandidateList candidates);

extern void make_fn_arguments(ParseState *pstate,
				  List *fargs,
				  Oid *actual_arg_types,
				  Oid *declared_arg_types);

extern const char *funcname_signature_string(const char *funcname, int nargs,
						  List *argnames, const Oid *argtypes);
extern const char *func_signature_string(List *funcname, int nargs,
					  List *argnames, const Oid *argtypes);

extern Oid LookupProcName(List *procname, bool noError);

#define LookupFuncName(a, b, c, d) (LookupFuncNameEx(a, b, c, d, T_FUNC, false))

#define LookupFuncNameTypeNames(a, b, c) (LookupFuncNameTypeNamesEx(a, b, c, T_FUNC, false, true))
 
extern Oid LookupFuncNameEx(List *funcname, int nargs, const Oid *argtypes,
				 bool noError, char protype, bool redwood_out_style);

extern Oid LookupFuncNameTypeNamesEx(List *funcname, List *argtypes,
						  bool noError, char protype, bool redwood_out_style, bool print_notice);

extern Oid LookupAggNameTypeNames(List *aggname, List *argtypes,
								  bool noError);

extern void parseFuncRawDefVals(ParseState *pstate, List *parameters, 
								Oid *param_types, ArrayType **defvals_arr);

extern List *getFuncDefValExprs(ParseState *pstate, Datum *arg_defvals, 
								int ndefvals, int offset);

extern Oid LookupTriggerFunc(List *funcname);

extern Node *convert_to_spl_out_style(ParseState *pstate,
						 HeapTuple proctup,
						 FuncExpr *funcexpr,
						 Oid rettype,
						 OutParamStyle out_param_style,
						 bool redwood_style_out);

/*
 * Name of the extra OUT param we add to SPL functions that have both OUT
 * params and a return value, to return the return value in. PostgreSQL
 * functions can't have both OUT params and a return value, which is why
 * we have to return the actual return value as an extra OUT param.
 */
#define RETVAL_STRING "_retval_"

extern void check_pg_get_expr_args(ParseState *pstate, Oid fnoid, List *args);

#endif   /* PARSE_FUNC_H */
