/*-------------------------------------------------------------------------
 *
 * parse_partition.h
 *	  handle Oracle-compatible partition syntax in parser
 *
 * Portions Copyright (c) 2011-2013, EnterpriseDB Corporation.
 *
 * src/include/parser/parse_partition.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef PARSE_PARTITION_H
#define PARSE_PARTITION_H

extern List *transformOraPartitions(List *objects, CreateStmt *parent, List *parentCols, void *pstate);
extern void CreatePartObjects(PartObjects *objects, const char *queryString);
extern void alterPartition(Relation rel, AlterTableType modtype, char *name, Node *node);

extern void RemovePartDefById(Oid partdefId);
extern void	 RemovePartitionById(Oid partitionId);

extern List *addPartitionRelids(List *objects, Oid relid);
extern Oid relGetPartDefId(Oid relid);
extern Oid relGetPartRoot(Oid relid);
extern List *relGetPartRels(Oid relid);
extern bool relIdIsPartitioned(Oid parent, bool *isRoot);
extern bool relIsPartitioned(Relation rel, bool *isRoot);

extern Oid findPartitionPartConstraint(Oid reloid);
extern Bitmapset *findPartColumns(Relation rel);
extern Datum partition_insert_trigger(PG_FUNCTION_ARGS);
extern Datum partition_update_trigger(PG_FUNCTION_ARGS);

extern RelPartInfo *RelationGetPartInfo(Relation relation);
extern List *preprune_partitions(RangeTblEntry *rte, Index rti, Node *quals, LOCKMODE lockmode);

#endif   /* PARSE_PARTITION_H */
