/*-------------------------------------------------------------------------
 *
 * edb_auditor.h
 *	  Exports from postmaster/edb_auditor.c.
 *
 *
 * src/include/postmaster/edb_auditor.h
 *
 * Copyright (c) 2004-2013, EnterpriseDB Corporation. All Rights Reserved.
 *
 *-------------------------------------------------------------------------
 */
#ifndef _EDB_AUDITOR_H
#define _EDB_AUDITOR_H

/*
 * Defines
 * 
 */


/* EDB Auditor Encoding */
#define EDB_AUDITOR_ENCODING "ISO-8859-1"


/* Values for 'edb_audit' */
#define		EDB_AUDIT_NONE	0
#define		EDB_AUDIT_XML	1
#define		EDB_AUDIT_CSV	2

/* Values for 'edb_audit_rotation_day' */
#define		EDB_AUDIT_ROTATION_DAY_NONE	0x00
#define		EDB_AUDIT_ROTATION_DAY_SUN	0x01
#define		EDB_AUDIT_ROTATION_DAY_MON	0x02
#define		EDB_AUDIT_ROTATION_DAY_TUE	0x04
#define		EDB_AUDIT_ROTATION_DAY_WED	0x08
#define		EDB_AUDIT_ROTATION_DAY_THU	0x10
#define		EDB_AUDIT_ROTATION_DAY_FRI	0x20
#define		EDB_AUDIT_ROTATION_DAY_SAT	0x40
#define		EDB_AUDIT_ROTATION_DAY_EVERY	(				\
						EDB_AUDIT_ROTATION_DAY_MON |	\
						EDB_AUDIT_ROTATION_DAY_TUE |	\
						EDB_AUDIT_ROTATION_DAY_WED |	\
						EDB_AUDIT_ROTATION_DAY_THU |	\
						EDB_AUDIT_ROTATION_DAY_FRI |	\
						EDB_AUDIT_ROTATION_DAY_SAT |	\
						EDB_AUDIT_ROTATION_DAY_SUN	\
						)
/* Values for 'edb_audit_connect' */
#define		EDB_AUDIT_CONNECT_NONE		0
#define		EDB_AUDIT_CONNECT_ALL		1
#define		EDB_AUDIT_CONNECT_FAILED	2

/* Values for 'edb_audit_disconnect' */
#define		EDB_AUDIT_DISCONNECT_NONE	0
#define		EDB_AUDIT_DISCONNECT_ALL	1

/* Values for 'edb_audit_statement' */
#define		EDB_AUDIT_STATEMENT_NONE	1
#define		EDB_AUDIT_STATEMENT_DML		2
#define		EDB_AUDIT_STATEMENT_DDL		4
#define		EDB_AUDIT_STATEMENT_ERROR	8
#define		EDB_AUDIT_STATEMENT_SELECT	0x10
#define		EDB_AUDIT_STATEMENT_ALL		0x20
#define		EDB_AUDIT_STATEMENT_ROLLBACK 0x40

/* Event Types */
#define		EDB_AUDITOR_COMMANDS_START		50

#define		EDB_AUDIT_EVENT_TYPE_INVALID		0
#define		EDB_AUDIT_EVENT_TYPE_GENERAL		1
#define		EDB_AUDIT_EVENT_TYPE_CONNECT		2
#define		EDB_AUDIT_EVENT_TYPE_CONNECT_FAILED	3
#define		EDB_AUDIT_EVENT_TYPE_DISCONNECT		4
#define		EDB_AUDIT_EVENT_TYPE_STARTUP		5
#define		EDB_AUDIT_EVENT_TYPE_SHUTDOWN		6
#define		EDB_AUDIT_EVENT_TYPE_ERROR		7

#define		EDB_AUDIT_EVENT_TYPE_DDL		(EDB_AUDITOR_COMMANDS_START + 1)
#define		EDB_AUDIT_EVENT_TYPE_DML		(EDB_AUDITOR_COMMANDS_START + 2)
#define		EDB_AUDIT_EVENT_TYPE_SELECT 		(EDB_AUDITOR_COMMANDS_START + 3)
#define		EDB_AUDIT_EVENT_TYPE_STATEMENT		(EDB_AUDITOR_COMMANDS_START + 4)
#define		EDB_AUDIT_EVENT_TYPE_ROLLBACK		(EDB_AUDITOR_COMMANDS_START + 5)

/*
 * extern variables
 */
extern int		Edb_audit;
extern char		*Edb_audit_directory;
extern char		*Edb_audit_filename;
extern int		Edb_audit_rotation_day;
extern int		Edb_audit_rotation_size;
extern int		Edb_audit_connect;
extern int		Edb_audit_disconnect;
extern int		Edb_audit_statement;
extern int		Edb_audit_rotation_seconds;
extern bool		Edb_was_logged;

#endif   /* _EDB_AUDITOR_H */
