/*-------------------------------------------------------------------------
 *
 * collectioncache.h
 *	  User-defined table type cache definitions.
 *
 * Portions Copyright (c) 2011-2013, EnterpriseDB Corporation
 * Portions Copyright (c) 1996-2010, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * src/include/utils/collectioncache.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef COLLECTIONCACHE_H
#define COLLECTIONCACHE_H

#include "fmgr.h"

extern int32 assign_collection_type_typmod(Oid keytype, Oid valuetype,
							  int32 valuetypmod, char typtype, int size_limit);
extern void lookup_collection_type(Oid type_id, int32 typmod, bool noError,
					   Oid *keytype, Oid *valuetype, int32 *valuetypmod,
					   char *typtype_p, int *size_limit_p);

#endif   /* COLLECTIONCACHE_H */
