/*-------------------------------------------------------------------------
 * collectionfuncs.h
 *	prototypes for functions in collectionfuncs.c
 *
 * Copyright (c) 2009-2013, EnterpriseDB Corporation
 *
 * src/include/utils/collectionfuncs.h
 *-------------------------------------------------------------------------
 */
#ifndef COLLECTIONFUNCS_H
#define COLLECTIONFUNCS_H

#include "postgres.h"
#include "utils/seqtree.h"

extern Datum udtabletype_constructor(PG_FUNCTION_ARGS);
extern Datum nestedtable_store(PG_FUNCTION_ARGS);
extern Datum udtable_lookup(PG_FUNCTION_ARGS);
extern Datum nestedtable_lookup(PG_FUNCTION_ARGS);
extern Datum udtable_store(PG_FUNCTION_ARGS);
extern Datum udtable_first(PG_FUNCTION_ARGS);
extern Datum udtable_last(PG_FUNCTION_ARGS);
extern Datum udtable_count(PG_FUNCTION_ARGS);
extern Datum udtable_exists(PG_FUNCTION_ARGS);
extern Datum udtable_next(PG_FUNCTION_ARGS);
extern Datum udtable_prior(PG_FUNCTION_ARGS);
extern Datum udtable_limit(PG_FUNCTION_ARGS);
extern Datum nestedtable_first(PG_FUNCTION_ARGS);
extern Datum nestedtable_last(PG_FUNCTION_ARGS);
extern Datum nestedtable_count(PG_FUNCTION_ARGS);
extern Datum udtable_exists(PG_FUNCTION_ARGS);
extern Datum nestedtable_next(PG_FUNCTION_ARGS);
extern Datum nestedtable_prior(PG_FUNCTION_ARGS);
extern Datum udtable_dumptree(PG_FUNCTION_ARGS);
extern Datum udtable_isbalanced(PG_FUNCTION_ARGS);
extern Datum udtable_delete1(PG_FUNCTION_ARGS);
extern Datum udtable_delete2(PG_FUNCTION_ARGS);
extern Datum udtable_delete3(PG_FUNCTION_ARGS);
extern Datum nestedtable_delete1(PG_FUNCTION_ARGS);
extern Datum nestedtable_delete2(PG_FUNCTION_ARGS);
extern Datum nestedtable_delete3(PG_FUNCTION_ARGS);
extern Datum udtable_neq(PG_FUNCTION_ARGS);
extern Datum udtable_multisetunion(PG_FUNCTION_ARGS);
extern Datum udtable_trim1(PG_FUNCTION_ARGS);
extern Datum udtable_trim2(PG_FUNCTION_ARGS);
extern Datum nestedtable_trim1(PG_FUNCTION_ARGS);
extern Datum nestedtable_trim2(PG_FUNCTION_ARGS);
extern Datum udtable_extend1(PG_FUNCTION_ARGS);
extern Datum udtable_extend2(PG_FUNCTION_ARGS);
extern Datum udtable_extend3(PG_FUNCTION_ARGS);
extern Datum nestedtable_extend1(PG_FUNCTION_ARGS);
extern Datum nestedtable_extend2(PG_FUNCTION_ARGS);
extern Datum nestedtable_extend3(PG_FUNCTION_ARGS);
extern Datum nestedtable_limit(PG_FUNCTION_ARGS);
extern Datum varray_constructor(PG_FUNCTION_ARGS);
extern Datum varray_lookup(PG_FUNCTION_ARGS);
extern Datum varray_first(PG_FUNCTION_ARGS);
extern Datum varray_last(PG_FUNCTION_ARGS);
extern Datum varray_count(PG_FUNCTION_ARGS);
extern Datum varray_next(PG_FUNCTION_ARGS);
extern Datum varray_prior(PG_FUNCTION_ARGS);
extern Datum varray_exists(PG_FUNCTION_ARGS);
extern Datum varray_limit(PG_FUNCTION_ARGS);
extern Datum varray_delete(PG_FUNCTION_ARGS);
extern Datum varray_trim1(PG_FUNCTION_ARGS);
extern Datum varray_trim2(PG_FUNCTION_ARGS);
extern Datum varray_extend1(PG_FUNCTION_ARGS);
extern Datum varray_extend2(PG_FUNCTION_ARGS);
extern Datum varray_extend3(PG_FUNCTION_ARGS);
extern Datum varray_store(PG_FUNCTION_ARGS);

extern void varray_insert(VarrayType **varray_data, int size_limit,
			  Datum index, Datum value, bool isnull,
			  SEQTREE_CACHE *collection_cache);
extern Datum varray_search(VarrayType *varray_data, int size_limit,
			  Datum index, bool *found, bool *isnull,
			  SEQTREE_CACHE *collection_cache);
extern int varray_count_internal(VarrayType *varray_data);

extern Datum nestedtable_search(SEQTREE *treep, Datum key, bool *found,
				   bool *isnull, SEQTREE_CACHE *cache);

#define IsCollectionLookupFuncid(funcid)		\
		(((funcid) == F_UDTABLE_LOOKUP ||		\
		  (funcid) == F_NESTEDTABLE_LOOKUP ||	\
		  (funcid) == F_VARRAY_LOOKUP))

#endif   /* COLLECTIONFUNCS_H */
