/*-------------------------------------------------------------------------
 *
 * dynatune
 *	  EnterpriseDB dynatune.h file definitions
 *
 * Copyright (c) 2004-2013, EnterpriseDB Corporation. All Rights Reserved.
 *
 *-------------------------------------------------------------------------
 */
#ifndef DYNATUNE_H
#define DYNATUNE_H

/* ========================================================================= */
/* << TYPE DEFINITION >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */
/* ========================================================================= */

#define DYNATUNE_VERSION	1						/* API/Structure Version */
#define MAX_STR_LEN   		50

#define	EDB_DYNATUNE_PROFILE_OLTP 1
#define	EDB_DYNATUNE_PROFILE_REPORTING 2
#define	EDB_DYNATUNE_PROFILE_MIXED 3

typedef struct
{	
	unsigned int structVersion;						/* Structure Version */

    /* +1 is for NULL Terminator */
	char		 osNameAndVersion[MAX_STR_LEN+1];	/* OS name and OS Version */
	char		 processorType[MAX_STR_LEN+1];		/* Processor Type */
	char		 processorArch[MAX_STR_LEN+1];		/* Processor Architecture */
	unsigned int processorCount;       				/* Number of Processors */
	float		 totalRamInBytes;          			/* Total system RAM (in bytes) */
	int64		 sharedMemInBytes;					/* Shared memory (in bytes) */
	float		 totalDbSize;						/* Total size of database files (in bytes) */
} t_info;

extern PGDLLIMPORT bool _debug_edb_utilization;
extern PGDLLIMPORT int  edb_dynatune;
extern PGDLLIMPORT int edb_dynatune_profile; /* in guc.c */

extern bool assign_edb_utilization(int percentage);
extern void log_edb_dynatune_settings(void);
extern void get_sys_info(t_info *pt_info);

#endif   /* DYNATUNE_H */
