/*
 * Copyright (c) 2004-2013, EnterpriseDB Corporation. All Rights Reserved.
 */

#include <postgres.h>
#include <utils/datetime.h>

#define COMPARE_FORMAT(x, y) (pg_strcasecmp(x, y) == 0)

#define CONVERSION_SUCCESS 0
#define CONVERSION_FAILED -1
#define MONTH_CHANGED 0x01
#define YEAR_CHANGED  0x02

#define FORMAT_LENGTH 25

typedef enum
{
	SUN = 0,
	MON,
	TUE,
	WED,
	THU,
	FRI,
	SAT
} WEEK_DAYS;

/*
 * utility functions for round/trunc date and time
 */

extern int format_parser(const char* strFormat, int strlength);
extern int format_error(struct pg_tm *tm, const char* format, int formatlength);
extern char decrease_date(struct pg_tm *tm);
extern char increase_date(struct pg_tm *tm);
extern WEEK_DAYS day_on_date(int date, int mon, int year);
extern int increase_month(struct pg_tm *tm);
extern int datetime_round(struct pg_tm *tm);
extern int increase_hour(struct pg_tm *tm);
extern int increase_minute(struct pg_tm *tm);
extern void verifyDateTime(struct pg_tm* tm);
extern bool isTodayInFirst4Days(WEEK_DAYS today, WEEK_DAYS firstday_of_week);

/*
 * functions to handle trunc date
 */
 
extern int trunc_century(struct pg_tm *tm, const char* format, int formatlength);
extern int trunc_year(struct pg_tm *tm, const char* format, int formatlength);
extern int trunc_isoweek(struct pg_tm *tm, const char* format, int formatlength);
extern int trunc_week(struct pg_tm *tm, const char* format, int formatlength);
extern int trunc_firstdayofweek(struct pg_tm *tm, const char* format, int formatlength);
extern int trunc_quarter(struct pg_tm *tm, const char* format, int formatlength);
extern int trunc_isoyear(struct pg_tm *tm, const char* format, int formatlength);
extern int trunc_month(struct pg_tm *tm, const char* format, int formatlength);
extern int trunc_day(struct pg_tm *tm, const char* format, int formatlength);
extern int trunc_hour(struct pg_tm *tm, const char* format, int formatlength);
extern int trunc_minute(struct pg_tm *tm, const char* format, int formatlength);
extern int trunc_month_week(struct pg_tm *tm, const char* format, int formatlength);

/*
 * functions to handle round date
 */

extern int round_century(struct pg_tm *tm, const char* format, int formatlength);
extern int round_year(struct pg_tm *tm, const char* format, int formatlength);
extern int round_isoweek(struct pg_tm *tm, const char* format, int formatlength);
extern int round_week(struct pg_tm *tm, const char* format, int formatlength);
extern int round_firstdayofweek(struct pg_tm *tm, const char* format, int formatlength);
extern int round_quarter(struct pg_tm *tm, const char* format, int formatlength);
extern int round_isoyear(struct pg_tm *tm, const char* format, int formatlength);
extern int round_month(struct pg_tm *tm, const char* format, int formatlength);
extern int round_day(struct pg_tm *tm, const char* format, int formatlength);
extern int round_hour(struct pg_tm *tm, const char* format, int formatlength);
extern int round_minute(struct pg_tm *tm, const char* format, int formatlength);
extern int round_month_week(struct pg_tm *tm, const char* format, int formatlength);
