/*
 * This header file is special. The includer must define the WAIT_EVENT
 * macro, to get the wait event names or enum keys.
 *
 * Copyright (c) 2004-2013, EnterpriseDB Corporation. All Rights Reserved.
 */


WAIT_EVENT(INVALID_WAIT_EVENT = 0, "empty wait event")
WAIT_EVENT(WAIT_ON_WAL_WRITE, "wal write")
WAIT_EVENT(WAIT_ON_WAL_FLUSH, "wal flush")
WAIT_EVENT(WAIT_ON_WAL_SYNC, "wal file sync")
WAIT_EVENT(WAIT_ON_BUFFER_FREE_LIST_LOCK, "buffer free list lock acquire")
WAIT_EVENT(WAIT_ON_SHMEM_INDEX_LOCK, "shmem index lock acquire")
WAIT_EVENT(WAIT_ON_OID_GEN_LOCK, "oid gen lock acquire")
WAIT_EVENT(WAIT_ON_XID_GEN_LOCK, "xid gen lock acquire")
WAIT_EVENT(WAIT_ON_PROC_ARRAY_LOCK, "proc array lock acquire")
WAIT_EVENT(WAIT_ON_SINVAL_READ_LOCK, "sinval lock acquire")
WAIT_EVENT(WAIT_ON_SINVAL_WRITE_LOCK, "freespace lock acquire")
WAIT_EVENT(WAIT_ON_WAL_INSERT_LOCK, "wal insert lock acquire")
WAIT_EVENT(WAIT_ON_WAL_WRITE_LOCK, "wal write lock acquire")
WAIT_EVENT(WAIT_ON_CONTROL_FILE_LOCK, "control file lock acquire")
WAIT_EVENT(WAIT_ON_CHECKPOINT_LOCK, "checkpoint lock acquire")
WAIT_EVENT(WAIT_ON_CLOG_CONTROL_LOCK, "clog control lock acquire")
WAIT_EVENT(WAIT_ON_SUBTRANS_CONTROL_LOCK, "subtrans control lock acquire")
WAIT_EVENT(WAIT_ON_MULTI_XACT_GEN_LOCK, "multi xact gen lock acquire")
WAIT_EVENT(WAIT_ON_MULTI_XACT_OFFSET_LOCK, "multi xact offset lock acquire")
WAIT_EVENT(WAIT_ON_MULTI_XACT_MEMBER_LOCK, "multi xact member lock acquire")
WAIT_EVENT(WAIT_ON_RELCACHE_INIT_LOCK, "rel cache init lock acquire")
WAIT_EVENT(WAIT_ON_BGWRITER_COMM_LOCK, "bgwriter communication lock acquire")
WAIT_EVENT(WAIT_ON_TWO_PHASE_STATE_LOCK, "two phase state lock acquire")
WAIT_EVENT(WAIT_ON_TABLESPACE_CREATE_LOCK, "tablespace create lock acquire")
WAIT_EVENT(WAIT_ON_BTREE_VACUUM_LOCK, "btree vacuum lock acquire")
WAIT_EVENT(WAIT_ON_ADD_IN_SHMEM_LOCK, "add in shmem lock acquire")
WAIT_EVENT(WAIT_ON_AUTOVACUUM_LOCK, "autovacuum lock acquire")
WAIT_EVENT(WAIT_ON_AUTOVACUUM_SCHEDULE_LOCK, "autovacuum schedule lock acquire")
WAIT_EVENT(WAIT_ON_SYNCSCAN_LOCK, "syncscan lock acquire")
WAIT_EVENT(WAIT_ON_ICACHE_LOCK, "icache lock acquire")
WAIT_EVENT(WAIT_ON_BREAKPOINT_LOCK, "breakpoint lock acquire")
WAIT_EVENT(WAIT_ON_LWLOCK, "lwlock acquire")
WAIT_EVENT(WAIT_ON_SMGR_READ, "db file read")
WAIT_EVENT(WAIT_ON_SMGR_WRITE, "db file write")
WAIT_EVENT(WAIT_ON_SMGR_SYNC, "db file sync")
WAIT_EVENT(WAIT_ON_SMGR_EXTEND, "db file extend")
WAIT_EVENT(WAIT_ON_QUERY_PARSE, "sql parse")
WAIT_EVENT(WAIT_ON_QUERY_PLAN, "query plan")
WAIT_EVENT(WAIT_ON_ICACHE_READ, "infinitecache read")
WAIT_EVENT(WAIT_ON_ICACHE_WRITE, "infinitecache write")

/* This *MUST* be the last entry */
WAIT_EVENT(HIGHEST_WAIT_EVENT_NUM, "invalid wait event")

