/*
 * pgsql/src/interfaces/ecpg/include/sqlda-proc.h
 *
 * Copyright (c) 2010-2013, EnterpriseDB Corporation.
 *
 *	This header defines an SQLDA type (and supporting functions)
 *	required when implementing a program that uses Oracle Dynamic
 *	SQL, Method 4.
 *
 *	Please note that the names used in this header are chosen
 *	by Oracle.
 */

#ifndef ECPG_SQLDA_PROC_H
#define ECPG_SQLDA_PROC_H

#include <stddef.h>

/*
 * SQLDA
 *
 *	This structure represents a dynamic SQL descriptor, as required
 *	by Oracle Dynamic SQL, Method 4.
 *
 *	The DESCRIBE SELECT LIST statement will populate an SQLDA with
 *	a description of the values returned by a query.
 *
 *	The DESCRIBE BIND VARIABLES statement populate an SQLDA with
 *	a description of each bind variable found in a prepared query.
 */
struct SQLDA
{
	int			N;				/* Number of entries						 */
	char	  **V;				/* Variables								 */
	int		   *L;				/* Variable lengths							 */
	short	   *T;				/* Variable types							 */
	short	  **I;				/* Indicators								 */
	int			F;				/* Count of variables discovered by DESCRIBE */
	char	  **S;				/* Variable names							 */
	short	   *M;				/* Variable name maximum lengths			 */
	short	   *C;				/* Variable name actual lengths				 */
	char	  **X;				/* Indicator names							 */
	short	   *Y;				/* Indicator name maximum lengths			 */
	short	   *Z;				/* Indicator name actual lengths			 */
};

typedef struct SQLDA SQLDA;

#define SQLSQLDAAlloc(ctx, varCount, varNameLen, indNameLen) sqlaldt(ctx, varCount, varNameLen, indNameLen)
#define SQLSQLDAFree(ctx, victim)							 sqlclut(ctx, victim)
#define SQLColumnNullCheck(ctx, valType, typeCode, isNull)	 sqlnult(ctx, valType typeCode, isNull)
#define SQLNumberPrecV7(ctx, length, precision, scale)		 sqlprct(ctx, length, precision, scale)

#endif   /* ECPG_SQLDA_PROC_H */
