#!/bin/sh
# Copyright (c) 2012-2014, EnterpriseDB Corporation.  All rights reserved

# Postgres Plus Advanced Server launcher files fix up script (for runAsRoot)
#
# Check the command line
if [ $# -ne 10 ]; 
then
    echo "Usage: $0 <Major.Minor version> <OSUsername> <SuperUsername> <Port> <Branding> <Install dir> <Data dir> <Mode> <ServiceName> <TEMP_DIR>"
    exit 127
fi

VERSION=$1
OSUSERNAME=$2
SUPERUSERNAME=$3
PORT=$4
BRANDING=$5
INSTALLDIR=$6
DATADIR=$7
DBMODE=$8
SERVICENAME=$9
shift
TEMP_DIR=$9
DATABASE="edb"

# Exit code
WARN=0

# Working directory
WD=`pwd`

# Version string, for the xdg filenames
VERSION_STR=`echo $VERSION | sed 's/\./_/g'`

# Branding string, for the xdg filenames. If the branding is 'Postgres Plus Advanced Server X.Y',
# Don't do anything to ensure we remain backwards compatible.
if [ "x$BRANDING" = "xPostgres Plus Advanced Server $VERSION" ];
then
    BRANDING_STR="Postgres_Plus_Advanced_Server_$VERSION_STR"
    BRANDED=0
else
    BRANDING_STR=`echo $BRANDING | sed 's/\./_/g' | sed 's/ /_/g'`
    BRANDED=1
fi

# Error handlers
_die() {
    echo $1
    exit 1
}

_warn() {
    echo $1
    WARN=2
}

# Search & replace in a file - _replace($find, $replace, $file) 
_replace() {
    sed -e "s^$1^$2^g" $3 > "$TEMP_DIR/$$.tmp" || _die "Failed for search and replace '$1' with '$2' in $3"
	mv $TEMP_DIR/$$.tmp $3 || _die "Failed to move $TEMP_DIR/$$.tmp to $3"
}

# Substitute values into a file ($in)
_fixup_file() {
    _replace EDB_VERSION_STR $VERSION_STR $1
    _replace EDB_MAJOR_VERSION $VERSION $1
    _replace EDB_SUPERUSERNAME $SUPERUSERNAME $1
    _replace EDB_OSUSERNAME $OSUSERNAME $1
    _replace EDB_PORT $PORT $1
    _replace EDB_INSTALLDIR "$INSTALLDIR" $1
    _replace EDB_DATADIR "$DATADIR" $1
    _replace EDB_DATABASE $DATABASE $1
    _replace EDB_BRANDING "$BRANDING" $1
    _replace EDB_SERVICENAME "$SERVICENAME" $1
}

#Set default database based on DBMODE
if [ $DBMODE = "postgresql" ]
then
  DATABASE="postgres"
else
  DATABASE="edb"
fi

# Fixup the scripts
_fixup_file "$INSTALLDIR/scripts/server/launchbrowser.sh"
_fixup_file "$INSTALLDIR/scripts/server/launchpsql.sh"
_fixup_file "$INSTALLDIR/scripts/server/psql.sh"
_fixup_file "$INSTALLDIR/scripts/server/launcheditconfig.sh"
_fixup_file "$INSTALLDIR/scripts/server/launchedithelper.sh"
_fixup_file "$INSTALLDIR/scripts/server/editconfig.sh"
_fixup_file "$INSTALLDIR/scripts/server/common.sh"
_fixup_file "$INSTALLDIR/scripts/server/launchsvrctl.sh"
_fixup_file "$INSTALLDIR/scripts/server/runpsql.sh"
_fixup_file "$INSTALLDIR/scripts/server/serverctl.sh"
chmod ugo+x "$INSTALLDIR/scripts/server/"*.sh

echo "$0 ran to completion"
exit 0
