#!/bin/sh
# Copyright (c) 2012-2014, EnterpriseDB Corporation.  All rights reserved

# PostgreSQL server shortcut removal script for Linux
# Dec 30, 2008 - Uzi - Modified for PostgresPlus AS

# Check the command line
if [ $# -ne 4 ]; 
then
    echo "Usage: $0 <Install dir> <Version> <Branding> <TEMP_DIR>"
    exit 127
fi

INSTALLDIR=$1
VERSION=$2
BRANDING=$3
TEMP_DIR=$4

# Exit code
WARN=0

# Working directory
WD=`pwd`

# Version string, for the xdg filenames
VERSION_STR=`echo $VERSION | sed 's/\./_/g'`

# Branding string, for the xdg filenames. If the branding is 'Postgres Plus Advanced Server X.Y',
# Don't do anything to ensure we remain backwards compatible.
if [ "x$BRANDING" = "xPostgres Plus Advanced Server $VERSION" ];
then
    BRANDING_STR="Postgres_Plus_Advanced_Server_$VERSION_STR"
    BRANDED=0
else
    BRANDING_STR=`echo $BRANDING | sed 's/\./_/g' | sed 's/ /_/g'`
    BRANDED=1
fi

TOP_LEVEL_MENUFILE="pg-$BRANDING_STR.directory"

# Error handlers
_die() {
    echo $1
    exit 1
}

_warn() {
    echo $1
    WARN=2
}

# Search & replace in a file - _replace($find, $replace, $file) 
_replace() {
        sed -e "s^$1^$2^g" $3 > "$TEMP_DIR/$$.tmp" || _die "Failed for search and replace '$1' with '$2' in $3"
        mv $TEMP_DIR/$$.tmp $3 || _die "Failed to move $TEMP_DIR/$$.tmp to $3"
}


# Remove the menu shortcuts
"$INSTALLDIR/installer/server/xdg/xdg-desktop-menu" uninstall --mode system --noupdate \
	  "$INSTALLDIR/scripts/server/xdg/ppas-expertconfig-$VERSION_STR.directory" \
          "$INSTALLDIR/scripts/server/xdg/ppas-editpostgresqlconf-$VERSION_STR.desktop" \
          "$INSTALLDIR/scripts/server/xdg/ppas-editpghbaconf-$VERSION_STR.desktop" \
          "$INSTALLDIR/scripts/server/xdg/ppas-editpgidentconf-$VERSION_STR.desktop" \
	  "$INSTALLDIR/scripts/server/xdg/ppas-reload-$VERSION_STR.desktop" || _warn "Failed to remove the top level menu"

"$INSTALLDIR/installer/server/xdg/xdg-desktop-menu" uninstall --mode system \
	  "$INSTALLDIR/scripts/server/xdg/ppas-psql-$VERSION_STR.desktop" || _warn "Failed to remove the top level menu"

# Remove the icon resources
cd "$INSTALLDIR/scripts/server/images"
for i in `ls *.png`
do
       filewosfx=${i%-*}
       if [ "$filewosfx" != "ppas-terminal" -a "$filewosfx" != "ppas-postgresql" ];
       then
         "$INSTALLDIR/installer/server/xdg/xdg-icon-resource" uninstall --mode system --size 32 $i
       fi
done

# Only remove the directory file if it's branded, otherwise, installer will remove it on its own.
if [ $BRANDED -ne 0 ];
then
    rm "$INSTALLDIR/scripts/server/xdg/$TOP_LEVEL_MENUFILE"
fi

xdg_dir_name=menus

xdg_system_dirs="$XDG_CONFIG_DIRS"
[ -n "$xdg_system_dirs" ] || xdg_system_dirs=/etc/xdg
xdg_global_dir=
for x in `echo $xdg_system_dirs | sed 's/:/ /g'` ; do
   if [ -w $x/$xdg_dir_name ] ; then
       xdg_global_dir="$x/$xdg_dir_name"
       break
   fi
done
xdg_global_dir="$xdg_global_dir/applications-merged"

# Hack up the XDG menu files to make sure everything really does go.
_replace "<Filename>ppas-editpostgresqlconf-$VERSION_STR.desktop</Filename>" "" "$xdg_global_dir/pg-$BRANDING_STR-ppas-expertconfig-$VERSION_STR.menu"
_replace "<Filename>ppas-editpgidentconf-$VERSION_STR.desktop</Filename>" "" "$xdg_global_dir/pg-$BRANDING_STR-ppas-expertconfig-$VERSION_STR.menu"
_replace "<Filename>ppas-editpghbaconf-$VERSION_STR.desktop</Filename>" "" "$xdg_global_dir/pg-$BRANDING_STR-ppas-expertconfig-$VERSION_STR.menu"
_replace "<Filename>ppas-reload-$VERSION_STR.desktop</Filename>" "" "$xdg_global_dir/pg-$BRANDING_STR-ppas-expertconfig-$VERSION_STR.menu"
_replace "<Filename>ppas-psql-$VERSION_STR.desktop</Filename>" "" "$xdg_global_dir/pg-$BRANDING_STR-ppas-runsqlcmdline-$VERSION_STR.menu"

#Ubuntu 10.04 and greater require menu cache update

if [ -f /usr/share/gnome-menus/update-gnome-menus-cache ];
then
   echo "Rebuilding menu cache files"
   find /usr/share/applications -iname \*${LANG}\*cache | while read filename; do 
      /usr/share/gnome-menus/update-gnome-menus-cache /usr/share/applications/ > $filename
   done
fi
echo "$0 ran to completion"
exit 0
