#!/bin/sh
# Copyright (c) 2012-2014, EnterpriseDB Corporation.  All rights reserved

openGuiEdit()
{
	for f in $EDITOR kwrite gedit kate
	do
       		which $f >/dev/null 2>&1
        	if [ $? -eq 0 ]
	        then
			`which $f` $filename
                	exit 0
	        fi
	done
}

openGuiCommandLine()
{
	CMD=""
	TITLE="EnterpriseDB"
	if [ -n "$2" ]
	then
		TITLE="$1"
		CMD="$2"
	else
		CMD="$1"
	fi
	for f in xterm konsole gnome-terminal
	do
       		which $f >/dev/null 2>&1
        	if [ $? -eq 0 ]
	        then
			if [ "$f" == "gnome-terminal" ]
                        then
                                echo "gnome terminal"
                                `which $f` -t "$TITLE" -e "$CMD"
                        else
                                `which $f` -T "$TITLE" -e $CMD
                        fi
                	exit 0
	        fi
	done
}

printClose()
{
	n=$1
	while [ "$n" -gt 0 ]
	do
        	echo -e -n "\rClosing in $n"
        	sleep 1
        	n=`expr $n - 1 `
	done
}

openGuiPdfReader()
{
	found=0
	for f in kpdf xpdf acroread evince
	do
		which $f >/dev/null 2>&1
		if [ $? -eq 0 ]
		then
			found=1
			`which $f` $1
			exit 0
		fi
	done

	if [ "$found" -eq 0 ]
	then
		# No PDF Viewer found
		echo "#!/bin/sh
		printf \"No PDF Reader found in your PATH\nPlease set your path or visit:\n http://www.adobe.com/support/downloads/product.jsp?product=10&platform=unix\n\n\"
		read any
		" > ~/noPdf.sh
		chmod 755 ~/noPdf.sh
		openGuiCommandLine "~/noPdf.sh"
		rm -f ~/noPdf.sh
	fi
}


