#!/bin/sh
# Copyright (c) 2012-2014, EnterpriseDB Corporation.  All rights reserved

# Include common functions
. EDB_INSTALLDIR/scripts/server/common.sh

filename=$1

xhost + >/dev/null 2>&1

# Try to figure out if this is a 'sudo' platform such as Ubuntu
USE_SUDO=0
if [ -f /etc/lsb-release ];
then
    if [ `grep -E '^DISTRIB_ID=[a-zA-Z]?buntu$' /etc/lsb-release | wc -l` != "0" ];
    then
        USE_SUDO=1
    fi
fi

if [ $USE_SUDO != "1" ];
then
    if [ `whoami` != "root" ];
    then
        echo "Please enter the root password when requested."
    fi
else
    echo "Please enter your password if requested."
fi

if [ $USE_SUDO != "1" ]
then    
        su - -c "nohup EDB_INSTALLDIR/scripts/server/editconfig.sh $filename >/dev/null 2>&1 & " 
else    
        sudo su -c "nohup EDB_INSTALLDIR/scripts/server/editconfig.sh $filename >/dev/null 2>&1 & "
fi

if [ $? -eq 1 ]
then
        printf "Invalid password\n"
fi

sleep 2
