#!/bin/sh
# Copyright (c) 2012-2014, EnterpriseDB Corporation.  All rights reserved

# PostgreSQL psql runner script for Linux

# Check the command line
if [ $# -ne 0 -a $# -ne 1 ]; 
then
    echo "Usage: $0 [wait]"
    exit 127
fi

validate_port()
{

  port=$1   
  
  nodigits=`echo $port | sed 's/[[:digit:]]//g'`
  
  if [ ! -z $nodigits ] ; then
       echo "Invalid port specified." 
       return 1
  fi
  
  if [ "$port" -le 0 ] ; then
       echo "Port specified must be greater than 0." 
       return 1
  fi
  if [ "$port" -ge 65536 ] ; then
       echo "Port specified must be less than 65536." 
       return 1
  fi
  return 0
}

echo -n "Server [localhost]: "
read SERVER

if [ "$SERVER" = "" ];
then
    SERVER="localhost"
fi

echo -n "Database [EDB_DATABASE]: "
read DATABASE

if [ "$DATABASE" = "" ];
then
    DATABASE="EDB_DATABASE"
fi

echo -n "Port [EDB_PORT]: "
read PORT

if [ "$PORT" = "" ];
then
    PORT="EDB_PORT"
fi

echo -n "Username [EDB_SUPERUSERNAME]: "
read USERNAME

if [ "$USERNAME" = "" ];
then
    USERNAME="EDB_SUPERUSERNAME"
fi

validate_port $PORT 

if [ $? = 0 ];
then
    "EDB_INSTALLDIR/bin/edb-psql" -h $SERVER -p $PORT -U $USERNAME $DATABASE
    RET=$?
else
    RET=1
fi
 
if [ "$RET" != "0" ];
then
    echo
    echo -n "Press <return> to continue..."
    read dummy
fi

exit $RET
