/* $Id: dblink_ora.sql.in,v 1.3 2007-02-07 15:24:03 ibrar Exp $
** ============================================================================
**                                 P O R T I C O
**           A REAL-TIME POSTGRESQL GATEWAY TO ONLINE ORACLE SYSTEMS
**
**      Portions Copyright (c) 2005 Jonah H. Harris. All Rights Reserved.
** ============================================================================
**
** FILENAME
**
**   dblink_ora.sql.in
**
** DESCRIPTION
**
**   This module represents an enterprise-grade database link which allows
**   you to query, insert, update, and delete data in an Oracle system from
**   within PostgreSQL.  It is based on the PostgreSQL dblink contrib module
**   and is similar in function to Oracle's database links.
**
**     CAUTION: If you don't know much about PostgreSQL's internals or Oracle's
**              OCI, it wouldn't be very wise to start messing with this code.
**              Consider yourself warned!
**
** NOTES
**
**   + This software requires Oracle client software to be installed and has
**     been tested with PostgreSQL 8.0.3 and the following clients:
**      - Oracle9i Client (9.2.0.4)
**      - Oracle10g Instant Client (10.1.0)
**   + This has been tested with PostgreSQL 8.0.3 against the following:
**      - Oracle9i Enterprise Edition Release 9.2.0.3.0
**      - Oracle9i Enterprise Edition Release 9.2.0.4.0
**      - Oracle10g Enterprise Edition Release 10.1.0.0.0
**
** USAGE
**
**   This code is to be included by dblink_ora.c
**
** COPYRIGHT ACKNOWLEDGEMENTS
**
**   Portions Copyright (c) 2005 Jonah H. Harris
**   Portions Copyright (c) 2001-2005 PostgreSQL Global Development Group
**
** ORIGINAL AUTHORS
**
**   Jonah H. Harris <jonah.harris@gmail.com>
**
** CONTRIBUTING AUTHORS
**
**   Joe Conway <mail@joeconway.com>
**   Darko Prenosil <Darko.Prenosil@finteh.hr>
**   Shridhar Daithankar <shridhar_daithankar@persistent.co.in>
**
** MAINTAINERS
**
**   Jonah H. Harris <jonah.harris@gmail.com>
**
** REFERENCE MATERIAL
**
**   http://otn.oracle.com/
**      - Oracle Call Interface Programmer's Guide (10.1)
**
**   http://www.postgresql.org/
**      - PostgreSQL Manual (8.x)
**
**   http://www.google.com/
**      - Misc. OCI Examples
**
** AKNOWLEDGEMENTS
**
**   Mike Stonebraker for INGRES, POSTGRES, and database-related theory.
**   Everyone responsible for Linux, BASH, PuTTY, and Vim.
**   Juan Valdez and his faithful burro Lana for the much-needed coffee.
**   The open source community for their idealism and vision.
**   The PostgreSQL development team for their continued support of the most
**      advanced open source database.
**   The original authors/contributors to PostgreSQL's dblink contrib module.
**   Oracle for charging so damn much that people want to switch.
**   EnterpriseDB for taking advantage of Oracle's poor business practices.
**
** TASK AGENDA
**
**   PRIORITY TASK
**   -------- -----------------------------------------------------------------
**   MEDIUM   Change functions returning text to returning bool
**   ======== =================================================================
**
** SOFTWARE LICENSE
**
**   Portions Copyright (c) 2005 Jonah H. Harris
**   Portions Copyright (c) 2001-2005 PostgreSQL Global Development Group
**   All Rights Reserved.
**
**   Permission to use, copy, modify, and distribute this software and its
**   documentation for any purpose, without fee, and without a written
**   agreement is hereby granted, provided that the above copyright notice and
**   this paragraph and the following two paragraphs appear in all copies.
**
**   IN NO EVENT SHALL THE AUTHOR OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR
**   DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING
**   LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS
**   DOCUMENTATION, EVEN IF THE AUTHOR OR DISTRIBUTORS HAVE BEEN ADVISED OF THE
**   POSSIBILITY OF SUCH DAMAGE.
**
**   THE AUTHOR AND DISTRIBUTORS SPECIFICALLY DISCLAIMS ANY WARRANTIES,
**   INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
**   AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
**   ON AN "AS IS" BASIS, AND THE AUTHOR AND DISTRIBUTORS HAS NO OBLIGATIONS TO
**   PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
**
** REVISION HISTORY
**
**       DATE    WHO TYP DESCRIPTION
**   ----------- --- --- ------------------------------------------------------
**   09-JUN-2005 JHH N/A Original Implementation (A Birthday Project!)
**   06-JUL-2005 JHH AUD Code functionality audit for EnterpriseDB
**   07-JUL-2005 JHH MOD Cleanup for possible delivery to EnterpriseDB
**   11-JUL-2005 JHH ADD dblink_ora_exec support back from the dead
** ============================================================================
*/

/* ------------------------------------------------------------------------- */

-- Function to create database connection
CREATE OR REPLACE FUNCTION dblink_ora_connect (text, -- Connection Name
                                               text, -- Hostname
                                               text, -- Service Name
                                               text, -- User Name
                                               text, -- Password
                                               int,  -- Port
                                               bool) -- isDBA
    RETURNS TEXT AS '$libdir/dblink_ora','dblink_ora_connect'
LANGUAGE C STRICT;

/* ------------------------------------------------------------------------- */

-- Function to create database connection, with isDba=false
CREATE OR REPLACE FUNCTION dblink_ora_connect (text, -- Connection Name
                                               text, -- Hostname
                                               text, -- Service Name
                                               text, -- User Name
                                               text, -- Password
                                               int)  -- Port
RETURNS text AS $$
	SELECT dblink_ora_connect($1, $2, $3, $4, $5, $6, false);
$$ LANGUAGE SQL STRICT;


/* ------------------------------------------------------------------------- */

-- Function to create database connection
CREATE OR REPLACE FUNCTION dblink_ora_connect (	text, -- Foreign Server Name
						bool) -- isDBA 
RETURNS TEXT AS '$libdir/dblink_ora','dblink_ora_connect_fs'
LANGUAGE C STRICT;

/* ------------------------------------------------------------------------- */

-- Function to create database connection
CREATE OR REPLACE FUNCTION dblink_ora_connect (text)
RETURNS TEXT AS $$ 
	SELECT dblink_ora_connect($1, false);
$$ LANGUAGE 'sql' STRICT;

/* ------------------------------------------------------------------------- */

-- Function to create database connection
CREATE OR REPLACE FUNCTION dblink_ora_status (text) -- Connection Name
    RETURNS TEXT AS '$libdir/dblink_ora','dblink_ora_status'
LANGUAGE C STRICT;

/* ------------------------------------------------------------------------- */

-- Function to close database connection
CREATE OR REPLACE FUNCTION dblink_ora_disconnect (text)
    RETURNS TEXT AS '$libdir/dblink_ora','dblink_ora_disconnect'
LANGUAGE C STRICT;

/* ------------------------------------------------------------------------- */

-- Function to return records from the database
CREATE OR REPLACE FUNCTION dblink_ora_record (text, -- Connection Name
                                              text) -- SQL Query
    RETURNS SETOF RECORD AS '$libdir/dblink_ora','dblink_ora_record'
LANGUAGE C STRICT;

/* ------------------------------------------------------------------------- */

-- Function to perform a CALL on the database
CREATE OR REPLACE FUNCTION dblink_ora_call (text, -- Connection Name
                                            text, -- SQL Query
                                            numeric) -- Oracle Num Iters
    RETURNS SETOF RECORD AS '$libdir/dblink_ora','dblink_ora_record'
LANGUAGE C STRICT;

/* ------------------------------------------------------------------------- */

-- Function to execute DML/DDL in the database
CREATE OR REPLACE FUNCTION dblink_ora_exec (text, -- Connection Name
                                            text) -- SQL INS/UPD/DEL
    RETURNS VOID AS '$libdir/dblink_ora','dblink_ora_exec'
LANGUAGE C STRICT;

/* ------------------------------------------------------------------------- */

-- Function to copy an Oracle table to an EnterpriseDB table
CREATE OR REPLACE FUNCTION dblink_ora_copy (text, -- Connection Name
                                            text, -- SQL INS/UPD/DEL
                                            text, -- Destination Schema Name
                                            text) -- Destination Table Name 
    RETURNS bigint AS '$libdir/dblink_ora','dblink_ora_copy'
LANGUAGE C STRICT;

CREATE OR REPLACE FUNCTION dblink_ora_copy (text, -- Connection Name
                                            text, -- SQL INS/UPD/DEL
                                            text, -- Destination Schema Name
                                            text, -- Destination Table Name
                                            bool) -- Truncate Table 
    RETURNS bigint AS '$libdir/dblink_ora','dblink_ora_copy'
LANGUAGE C STRICT;

CREATE OR REPLACE FUNCTION dblink_ora_copy (text, -- Connection Name
                                            text, -- SQL INS/UPD/DEL
                                            text, -- Destination Schema Name
                                            text, -- Destination Table Name
                                            bool, -- Truncate Table
                                            int)  -- Feedback count
    RETURNS bigint AS '$libdir/dblink_ora','dblink_ora_copy'
LANGUAGE C STRICT;


/* ------------------------------------------------------------------------- */

/* TEST BUILDER FUNCTION */
/*
CREATE TYPE ora_apr_user_type AS (user_id varchar, birth_date varchar, ssn_last_four varchar, banner_id varchar, campus varchar);
CREATE OR REPLACE FUNCTION get_ora_user_record (userName VARCHAR)
    RETURNS SETOF ora_apr_user_type AS $$
DECLARE
    t_rec RECORD;
BEGIN
   FOR t_rec IN (
    SELECT
        *
    FROM
        dblink_ora('select * from apr_users WHERE user_id = \'' || userName || '\'')
        AS t1(user_id varchar, birth_date varchar, ssn_last_four varchar, banner_id varchar, campus varchar)
    )
    LOOP
        RETURN NEXT t_rec;
    END LOOP;

    RETURN;

END;
$$ LANGUAGE 'plpgsql' IMMUTABLE;
*/
