SET search_path = sys;

CREATE OR REPLACE PACKAGE dbms_job IS

	any_instance CONSTANT INTEGER := NULL;

	PROCEDURE SUBMIT(job OUT INTEGER, what VARCHAR, next_date TIMESTAMP DEFAULT clock_timestamp(), 
					"interval" VARCHAR DEFAULT NULL, no_parse BOOLEAN DEFAULT FALSE,
					instance INTEGER DEFAULT any_instance, force BOOLEAN DEFAULT FALSE);

	PROCEDURE RUN(job INTEGER, force BOOLEAN DEFAULT FALSE);

	PROCEDURE "interval"(job INTEGER, "interval" VARCHAR2);

	PROCEDURE REMOVE(job INTEGER);

	PROCEDURE NEXT_DATE(job INTEGER, next_date TIMESTAMP);

	PROCEDURE WHAT(job INTEGER, what VARCHAR2);

	PROCEDURE CHANGE(job INTEGER, what VARCHAR2, next_date TIMESTAMP,
					 "interval" VARCHAR2, instance INTEGER DEFAULT NULL,
					 force BOOLEAN DEFAULT FALSE);

	PROCEDURE BROKEN(job INTEGER, broken BOOLEAN,
					 next_date TIMESTAMP DEFAULT clock_timestamp());
END;

