SET search_path = sys;

CREATE OR REPLACE PACKAGE DBMS_LOB 
IS
	WARN_INCONVERTIBLE_CHAR CONSTANT	INTEGER 	DEFAULT 1;
	DEFAULT_CSID            CONSTANT	INTEGER 	DEFAULT 0;
	DEFAULT_LANG_CTX        CONSTANT	INTEGER 	DEFAULT 0;
	NO_WARNING              CONSTANT	INTEGER 	DEFAULT 0;
	LOBMAXSIZE      		CONSTANT	INTEGER 	DEFAULT 1073741823;
	FILE_READONLY   		CONSTANT	INTEGER 	DEFAULT 0;
	LOB_READONLY    		CONSTANT	INTEGER 	DEFAULT 0;
	LOB_READWRITE   		CONSTANT	INTEGER 	DEFAULT 1;
	SESSION		     		CONSTANT	INTEGER 	DEFAULT 10;
	CALL             		CONSTANT	INTEGER 	DEFAULT 12;
	OPT_COMPRESS    		CONSTANT	INTEGER 	DEFAULT 1;
	OPT_ENCRYPT     		CONSTANT	INTEGER 	DEFAULT 2;
	OPT_DEDUPLICATE 		CONSTANT	INTEGER 	DEFAULT 4;
	COMPRESS_OFF    		CONSTANT	INTEGER 	DEFAULT 0;
	COMPRESS_ON     		CONSTANT	INTEGER 	DEFAULT 1;
	ENCRYPT_OFF     		CONSTANT	INTEGER 	DEFAULT 0;
	ENCRYPT_ON      		CONSTANT	INTEGER 	DEFAULT 2;
	DEDUPLICATE_OFF 		CONSTANT	INTEGER 	DEFAULT 0;
	DEDUPLICATE_ON  		CONSTANT	INTEGER 	DEFAULT 4;

	/* APPEND */
	PROCEDURE APPEND(dest_lob   IN OUT BLOB, 
					 src_lob           BLOB);
	PROCEDURE APPEND(dest_lob   IN OUT CLOB, 
					 src_lob           CLOB);

	/* GETLENGTH */
	FUNCTION GETLENGTH(lob_loc  IN     BLOB) RETURN INTEGER;
	FUNCTION GETLENGTH(lob_loc  IN     CLOB) RETURN INTEGER;

	/* SUBSTR */
	FUNCTION SUBSTR(lob_loc     IN     BLOB,
					amount      IN     INTEGER  DEFAULT 32767,
					"offset"    IN     INTEGER  DEFAULT 1)
	  RETURN RAW;

	FUNCTION SUBSTR(lob_loc     IN     CLOB,
					amount      IN     INTEGER  DEFAULT 32767,
					"offset"    IN     INTEGER  DEFAULT 1)
	  RETURN VARCHAR2;

	/* INSTR */
	FUNCTION INSTR(lob_loc    IN   BLOB,
				   pattern    IN   RAW,
				   "offset"   IN   INTEGER default 1,
				   nth        IN   INTEGER default 1)
  	  RETURN INTEGER;

	FUNCTION INSTR(lob_loc    IN   CLOB,
				   pattern    IN   VARCHAR,
				   "offset"   IN   INTEGER default 1,
				   nth        IN   INTEGER default 1)
	  RETURN INTEGER;

	/* READ */
	PROCEDURE READ(lob_loc    IN       BLOB, 
				   amount     IN OUT   INTEGER, 
				   "offset"   IN       INTEGER, 
				   buffer     OUT      RAW);

    PROCEDURE READ(lob_loc    IN       CLOB, 
                   amount     IN OUT   INTEGER, 
                   "offset"   IN       INTEGER, 
                   buffer     OUT      VARCHAR);

    /* COMPARE */
    FUNCTION COMPARE(lob_1    IN     BLOB,
                     lob_2    IN     BLOB,
                     amount   IN     INTEGER   DEFAULT 1073741823,
                     offset_1 IN     INTEGER   DEFAULT 1,
                     offset_2 IN     INTEGER   DEFAULT 1)
      RETURN INTEGER;

    FUNCTION COMPARE(lob_1      IN     CLOB,
                     lob_2      IN     CLOB,
                     amount     IN     INTEGER   DEFAULT 1073741823,
                     offset_1   IN     INTEGER   DEFAULT 1,
                     offset_2   IN     INTEGER   DEFAULT 1)
      RETURN INTEGER;

    /* WRITEAPPEND */
    PROCEDURE WRITEAPPEND(lob_loc    IN OUT   BLOB, 
                          amount     IN       INTEGER, 
                          buffer     IN       RAW(32767));

    PROCEDURE WRITEAPPEND(lob_loc    IN OUT   CLOB,
                          amount     IN       INTEGER, 
                          buffer     IN       VARCHAR(32767));

    /* WRITE */
    PROCEDURE WRITE(lob_loc    IN OUT  CLOB, 
                    amount     IN      INTEGER, 
                    "offset"   IN      INTEGER, 
                    buffer     IN      VARCHAR(32767));

    PROCEDURE WRITE(lob_loc    IN OUT  BLOB, 
                    amount     IN      INTEGER, 
                    "offset"   IN      INTEGER, 
                    buffer     IN      RAW(32767));

    /* GET_STORAGE_LIMIT */
    FUNCTION GET_STORAGE_LIMIT(lob_loc BLOB) RETURNS INTEGER;
    FUNCTION GET_STORAGE_LIMIT(lob_loc CLOB) RETURNS INTEGER;

    /* TRIM */
    PROCEDURE "trim"(lob_loc    IN OUT  CLOB, 
                     newLen     IN      INTEGER);

    PROCEDURE "trim"(lob_loc    IN OUT  BLOB, 
                     newLen     IN      INTEGER);

    /* ERASE */
    PROCEDURE ERASE(lob_loc    IN OUT  CLOB, 
                    amount     IN OUT  INTEGER, 
                    "offset"   IN      INTEGER  DEFAULT 1);

    PROCEDURE ERASE(lob_loc    IN OUT  BLOB, 
                    amount     IN OUT  INTEGER, 
                    "offset"   IN      INTEGER  DEFAULT 1);

    /* COPY */
    PROCEDURE COPY(dest_lob    IN OUT  BLOB, 
                   src_lob     IN      BLOB, 
                   amount      IN      INTEGER, 
                   dest_offset IN      INTEGER  DEFAULT 1, 
                   src_offset  IN      INTEGER  DEFAULT 1);

    PROCEDURE COPY(dest_lob    IN OUT  CLOB, 
                   src_lob     IN      CLOB, 
                   amount      IN      INTEGER, 
                   dest_offset IN      INTEGER  DEFAULT 1, 
                   src_offset  IN      INTEGER  DEFAULT 1);

	PROCEDURE CONVERTTOBLOB (dest_lob     IN OUT   BLOB, 
							 src_clob     IN       CLOB, 
							 amount       IN       INTEGER, 
							 dest_offset  IN OUT   INTEGER, 
							 src_offset   IN OUT   INTEGER, 
							 blob_csid    IN       INTEGER, 
							 lang_context IN OUT   INTEGER, 
							 warning      OUT      INTEGER);

	PROCEDURE CONVERTTOCLOB (dest_lob     IN OUT    CLOB, 
							 src_blob     IN        BLOB, 
							 amount       IN        INTEGER, 
							 dest_offset  IN OUT    INTEGER, 
							 src_offset   IN OUT    INTEGER, 
							 blob_csid    IN        INTEGER, 
							 lang_context IN OUT    INTEGER, 
							 warning      OUT       INTEGER);
END;

