--Adjust this setting to control where the objects get created.
SET search_path = sys;

CREATE OR REPLACE PACKAGE dbms_mview IS

  -- REFRESH
  -- With comma separated list
  PROCEDURE refresh(
    list                 IN VARCHAR2,
    method               IN VARCHAR2  DEFAULT NULL,
    rollback_seg         IN VARCHAR2  DEFAULT NULL,
    push_deferred_rpc    IN BOOLEAN   DEFAULT TRUE,
    refresh_after_errors IN BOOLEAN   DEFAULT FALSE,
    purge_option         IN NUMBER    DEFAULT 1,
    parallelism          IN NUMBER    DEFAULT 0,
    heap_size            IN NUMBER    DEFAULT 0,
    atomic_refresh       IN BOOLEAN   DEFAULT TRUE,
    nested               IN BOOLEAN   DEFAULT FALSE);

  -- With names in dbms_utility.uncl_array
  PROCEDURE refresh(
    tab                  IN OUT dbms_utility.uncl_array,
    method               IN     VARCHAR2  DEFAULT NULL,
    rollback_seg         IN     VARCHAR2  DEFAULT NULL,
    push_deferred_rpc    IN     BOOLEAN   DEFAULT TRUE,
    refresh_after_errors IN     BOOLEAN   DEFAULT FALSE,
    purge_option         IN     NUMBER    DEFAULT 1,
    parallelism          IN     NUMBER    DEFAULT 0,
    heap_size            IN     NUMBER    DEFAULT 0,
    atomic_refresh       IN     BOOLEAN   DEFAULT TRUE,
    nested               IN     BOOLEAN   DEFAULT FALSE);

  -- REFRESH_DEPENDENT (Given master table, refresh all dependent MVs)
  -- With comma separated list
  PROCEDURE refresh_dependent(
    number_of_failures   OUT BINARY_INTEGER,
    list                 IN  VARCHAR2,
    method               IN  VARCHAR2  DEFAULT NULL,
    rollback_seg         IN  VARCHAR2  DEFAULT NULL,
    refresh_after_errors IN  BOOLEAN   DEFAULT FALSE,
    atomic_refresh       IN  BOOLEAN   DEFAULT TRUE,
    nested               IN  BOOLEAN   DEFAULT FALSE);

  -- With names in dbms_utility.uncl_array
  PROCEDURE refresh_dependent(
    number_of_failures   OUT BINARY_INTEGER,
    tab                  IN  dbms_utility.uncl_array,
    method               IN  VARCHAR2  DEFAULT NULL,
    rollback_seg         IN  VARCHAR2  DEFAULT NULL,
    refresh_after_errors IN  BOOLEAN   DEFAULT FALSE,
    atomic_refresh       IN  BOOLEAN   DEFAULT TRUE,
    nested               IN  BOOLEAN   DEFAULT FALSE);

  -- REFRESH_ALL_MVIEWS (refresh all MVs)
  PROCEDURE refresh_all_mviews(
    number_of_failures   OUT BINARY_INTEGER,
    method               IN  VARCHAR2  DEFAULT NULL,
    rollback_seg         IN  VARCHAR2  DEFAULT NULL,
    refresh_after_errors IN  BOOLEAN   DEFAULT FALSE,
    atomic_refresh       IN  BOOLEAN   DEFAULT TRUE);

  -- GET_MV_DEPENDENCIES (Given list of tables/MVs, return dependent MVs)
  PROCEDURE get_mv_dependencies(
    list    IN  VARCHAR2,
    deplist OUT VARCHAR2);

END dbms_mview;
