-- Adjust this setting to control where the objects get created.
SET search_path = sys;

CREATE OR REPLACE PACKAGE DBMS_PIPE IS
	FUNCTION CREATE_PIPE(
		pipename VARCHAR2(128),
		maxpipesize INTEGER DEFAULT 8192,
		private BOOL DEFAULT TRUE
		) RETURN INTEGER;
		
	FUNCTION REMOVE_PIPE(pipename VARCHAR2(128)) RETURN INTEGER;
	FUNCTION SEND_MESSAGE(
		pipename VARCHAR2(128),
		timeout INTEGER DEFAULT 86400000,
		maxpipesize INTEGER DEFAULT 8192
		) RETURN INT;
		
	FUNCTION RECEIVE_MESSAGE(
		pipename VARCHAR2(128),
		timeout INTEGER DEFAULT 86400000
		) RETURN INT;
		
	FUNCTION NEXT_ITEM_TYPE RETURN INT;
	PROCEDURE PURGE(pipename VARCHAR2(128));
	PROCEDURE RESET_BUFFER;
	FUNCTION UNIQUE_SESSION_NAME RETURN VARCHAR2;
	
	PROCEDURE PACK_MESSAGE(item NUMBER);
	PROCEDURE PACK_MESSAGE(item VARCHAR2);
	PROCEDURE PACK_MESSAGE(item DATE);
	PROCEDURE PACK_MESSAGE_RAW(item RAW);
	
	PROCEDURE UNPACK_MESSAGE(item OUT NUMBER);
	PROCEDURE UNPACK_MESSAGE(item OUT VARCHAR2);
	PROCEDURE UNPACK_MESSAGE(item OUT DATE);
	PROCEDURE UNPACK_MESSAGE_RAW(item OUT RAW);
END;

